/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.knapsack;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.opt4j.benchmarks.knapsack.Item;
import org.opt4j.benchmarks.knapsack.ItemSelection;
import org.opt4j.benchmarks.knapsack.KnapsackProblem;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.BooleanMapGenotype;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;

public class KnapsackBinaryCreatorDecoder
implements Creator<BooleanMapGenotype<Item>>,
Decoder<BooleanMapGenotype<Item>, ItemSelection> {
    private final List<Item> itemList = new ArrayList<Item>();
    private final Rand random;

    @Inject
    public KnapsackBinaryCreatorDecoder(KnapsackProblem problem, Rand random) {
        this.random = random;
        this.itemList.addAll(problem.getItems());
    }

    public ItemSelection decode(BooleanMapGenotype<Item> genotype) {
        ItemSelection itemSelection = new ItemSelection();
        for (Item item : this.itemList) {
            if (!genotype.getValue((Object)item).booleanValue()) continue;
            itemSelection.add(item);
        }
        return itemSelection;
    }

    public BooleanMapGenotype<Item> create() {
        BooleanMapGenotype b = new BooleanMapGenotype(this.itemList);
        b.init((Random)this.random);
        return b;
    }
}

