/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.dtlz;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opt4j.benchmarks.M;
import org.opt4j.benchmarks.N;
import org.opt4j.benchmarks.dtlz.DTLZEvaluator;

public class DTLZ2
extends DTLZEvaluator {
    @Inject
    public DTLZ2(@M int m, @N int n) {
        super(m, n);
    }

    @Override
    protected List<Double> f(List<Double> x, double g) {
        ArrayList<Double> f = new ArrayList<Double>();
        double a = 1.0 + g;
        for (int i = 0; i < this.m; ++i) {
            if (i > 0) {
                a *= Math.cos(Math.PI * x.get(i - 1) / 2.0);
            }
            double value = a;
            if (i < x.size()) {
                value *= Math.sin(Math.PI * x.get(i) / 2.0);
            }
            f.add(value);
        }
        Collections.reverse(f);
        return f;
    }

    @Override
    protected double g(List<Double> x) {
        double g = 0.0;
        for (double e : x) {
            g += (e - 0.5) * (e - 0.5);
        }
        return g;
    }
}

