/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks;

import com.google.inject.Inject;
import java.util.List;
import org.opt4j.benchmarks.BinaryString;
import org.opt4j.benchmarks.Bits;
import org.opt4j.benchmarks.DoubleString;
import org.opt4j.benchmarks.N;
import org.opt4j.core.problem.Decoder;

public class BinaryToDoubleDecoder
implements Decoder<BinaryString, DoubleString> {
    protected final int n;
    protected final int bits;

    @Inject
    public BinaryToDoubleDecoder(@N int n, @Bits int bits) {
        this.n = n;
        this.bits = bits;
    }

    public DoubleString decode(BinaryString genotype) {
        DoubleString phenotype = new DoubleString();
        for (int i = 0; i < this.n; ++i) {
            int begin = i * this.bits;
            int end = begin + this.bits;
            double x = this.toDouble((List<Boolean>)((Object)genotype), begin, end);
            phenotype.add(x);
        }
        return phenotype;
    }

    private double toDouble(List<Boolean> list, int begin, int end) {
        int b = 1;
        boolean sum = false;
        for (int i = end - 1; i >= begin; --i) {
            if (list.get(i).booleanValue()) {
                sum |= b;
            }
            b <<= 1;
        }
        return (double)sum / (double)b;
    }
}

