/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.util.Path;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultHttpContext
implements WebContainerContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpContext.class);
    private final Bundle bundle;

    DefaultHttpContext(Bundle bundle) {
        NullArgumentException.validateNotNull(bundle, "Bundle");
        this.bundle = bundle;
    }

    @Override
    public boolean handleSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return true;
    }

    @Override
    public URL getResource(String name) {
        String normalizedname = Path.normalizeResourcePath(name);
        LOG.debug("Searching bundle [" + this.bundle + "] for resource [" + normalizedname + "]");
        return this.bundle.getResource(normalizedname);
    }

    @Override
    public String getMimeType(String name) {
        return null;
    }

    @Override
    public Set<String> getResourcePaths(String name) {
        String normalizedname = Path.normalizeResourcePath(name);
        LOG.debug("Searching bundle [" + this.bundle + "] for resource paths of [" + normalizedname + "]");
        Enumeration entryPaths = this.bundle.getEntryPaths(normalizedname);
        if (entryPaths == null || !entryPaths.hasMoreElements()) {
            return null;
        }
        HashSet<String> foundPaths = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            foundPaths.add((String)entryPaths.nextElement());
        }
        return foundPaths;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.bundle.getSymbolicName() + " - " + this.bundle.getBundleId() + "}";
    }
}

