/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleUtils {
    public static BundleContext getBundleContext(Bundle bundle) {
        try {
            Method method = bundle.getClass().getDeclaredMethod("getBundleContext", new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (BundleContext)method.invoke((Object)bundle, new Object[0]);
        }
        catch (Exception e) {
            try {
                Field[] fields;
                for (Field field : fields = bundle.getClass().getDeclaredFields()) {
                    if (!BundleContext.class.isAssignableFrom(field.getType())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return (BundleContext)field.get(bundle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static Bundle getBundle(BundleContext bc, String symbolicName) {
        return BundleUtils.getBundle(bc, symbolicName, null);
    }

    public static List<Bundle> getBundles(BundleContext bc, String symbolicName) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Bundle bundle : bc.getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    public static Bundle getBundle(BundleContext bc, String symbolicName, String version) {
        for (Bundle bundle : bc.getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName) || version != null && !version.equals(bundle.getVersion())) continue;
            return bundle;
        }
        return null;
    }
}

