/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.internal.ConfigurationImpl;
import org.ops4j.pax.web.service.internal.DefaultPropertyResolver;
import org.ops4j.pax.web.service.internal.HttpServiceFactoryImpl;
import org.ops4j.pax.web.service.internal.HttpServiceProxy;
import org.ops4j.pax.web.service.internal.HttpServiceStarted;
import org.ops4j.pax.web.service.internal.ServletEventDispatcher;
import org.ops4j.pax.web.service.internal.util.ConfigAdminSupportUtils;
import org.ops4j.pax.web.service.internal.util.JspSupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.FallbackPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private final Lock m_lock = new ReentrantLock();
    private ServerController m_serverController;
    private boolean m_serverControllerDefaultConfigured;
    private ServerModel m_serverModel;
    private ServiceRegistration m_httpServiceFactoryReg;
    private Dictionary<String, Object> m_httpServiceFactoryProps;
    private BundleContext bundleContext;
    private ScheduledExecutorService executors;
    private ServletEventDispatcher servletEventDispatcher;
    private ServiceTracker eventServiceTracker;
    private ServiceTracker logServiceTracker;
    private ServiceTracker dynamicsServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        LOG.debug("Starting Pax Web");
        this.bundleContext = bundleContext;
        this.m_serverModel = new ServerModel();
        this.executors = Executors.newScheduledThreadPool(3, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("WebListenerExecutor: " + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        this.servletEventDispatcher = new ServletEventDispatcher(bundleContext, this.executors);
        Filter filterEvent = bundleContext.createFilter("(objectClass=org.osgi.service.event.EventAdmin)");
        this.eventServiceTracker = new ServiceTracker(bundleContext, filterEvent, (ServiceTrackerCustomizer)new EventServiceCustomizer());
        this.eventServiceTracker.open();
        Filter filterLog = bundleContext.createFilter("(objectClass=org.osgi.service.log.LogService)");
        this.logServiceTracker = new ServiceTracker(bundleContext, filterLog, (ServiceTrackerCustomizer)new LogServiceCustomizer());
        this.logServiceTracker.open();
        this.dynamicsServiceTracker = new ServiceTracker(bundleContext, ServerControllerFactory.class.getName(), (ServiceTrackerCustomizer)new DynamicsServiceTrackerCustomizer());
        this.dynamicsServiceTracker.open();
        LOG.info("Pax Web started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOG.debug("Stopping Pax Web");
        if (this.m_serverController != null) {
            this.m_serverController.stop();
            this.m_serverController = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        if (this.eventServiceTracker != null) {
            this.eventServiceTracker.close();
            this.eventServiceTracker = null;
        }
        if (this.dynamicsServiceTracker != null) {
            this.dynamicsServiceTracker.close();
            this.dynamicsServiceTracker = null;
        }
        if (this.executors != null) {
            this.executors.shutdown();
            this.executors.awaitTermination(500L, TimeUnit.MILLISECONDS);
            this.executors = null;
        }
        this.servletEventDispatcher.destroy();
        this.m_serverControllerDefaultConfigured = false;
        this.m_serverModel = null;
        LOG.info("Pax Web stopped");
    }

    private void createHttpServiceFactory(BundleContext bundleContext) {
        LOG.debug("createHttpServiceFactory");
        this.m_httpServiceFactoryReg = bundleContext.registerService(new String[]{HttpService.class.getName(), WebContainer.class.getName()}, (Object)new HttpServiceFactoryImpl(){

            @Override
            HttpService createService(Bundle bundle) {
                LOG.debug("creating service for Bundle {}", (Object)bundle.getSymbolicName());
                return new HttpServiceProxy(new HttpServiceStarted(bundle, Activator.this.m_serverController, Activator.this.m_serverModel, Activator.this.servletEventDispatcher));
            }
        }, this.m_httpServiceFactoryProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManagedService(final BundleContext bundleContext) {
        ManagedService managedService = new ManagedService(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updated(Dictionary config) throws ConfigurationException {
                try {
                    boolean aboutToDefaultConfigure;
                    FallbackPropertyResolver resolver;
                    Activator.this.m_lock.lock();
                    if (config == null) {
                        if (Activator.this.m_serverControllerDefaultConfigured) {
                            return;
                        }
                        resolver = new BundleContextPropertyResolver(bundleContext, new DefaultPropertyResolver());
                        aboutToDefaultConfigure = true;
                    } else {
                        resolver = new DictionaryPropertyResolver(config, new BundleContextPropertyResolver(bundleContext, new DefaultPropertyResolver()));
                        aboutToDefaultConfigure = false;
                    }
                    ConfigurationImpl configuration = new ConfigurationImpl(resolver);
                    Activator.this.m_serverController.configure(configuration);
                    Activator.this.determineServiceProperties(config, configuration, Activator.this.m_serverController.getHttpPort(), Activator.this.m_serverController.getHttpSecurePort());
                    if (Activator.this.m_httpServiceFactoryReg != null) {
                        Activator.this.m_httpServiceFactoryReg.setProperties(Activator.this.m_httpServiceFactoryProps);
                    }
                    Activator.this.m_serverControllerDefaultConfigured = aboutToDefaultConfigure;
                }
                finally {
                    Activator.this.m_lock.unlock();
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.web");
        bundleContext.registerService(ManagedService.class.getName(), (Object)managedService, props);
        try {
            this.m_lock.lock();
            if (!this.m_serverController.isConfigured()) {
                try {
                    managedService.updated(null);
                }
                catch (ConfigurationException ignore) {
                    LOG.error("Internal error. Cannot set initial configuration resolver.", (Throwable)ignore);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    private void determineServiceProperties(Dictionary managedConfig, Configuration config, Integer httpPort, Integer httpSecurePort) {
        Hashtable<String, Object> toPropagate = new Hashtable<String, Object>();
        if (managedConfig != null && !managedConfig.isEmpty()) {
            Enumeration enumeration = managedConfig.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                toPropagate.put(key, managedConfig.get(key));
            }
        }
        this.setProperty(toPropagate, "org.osgi.service.http.enabled", config.isHttpEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port", config.getHttpPort());
        this.setProperty(toPropagate, "org.osgi.service.http.connector.name", config.getHttpConnectorName());
        this.setProperty(toPropagate, "org.osgi.service.http.secure.enabled", config.isHttpEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", config.getHttpSecurePort());
        this.setProperty(toPropagate, "org.osgi.service.http.secure.connector.name", config.getHttpSecureConnectorName());
        this.setProperty(toPropagate, "org.osgi.service.http.useNIO", config.useNIO());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthneeded", config.isClientAuthNeeded());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthwanted", config.isClientAuthWanted());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore", config.getSslKeystore());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore.type", config.getSslKeystoreType());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.password", config.getSslPassword());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keypassword", config.getSslKeyPassword());
        this.setProperty(toPropagate, "javax.servlet.context.tempdir", config.getTemporaryDirectory());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.timeout", config.getSessionTimeout());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.url", config.getSessionUrl());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.cookie", config.getSessionCookie());
        this.setProperty(toPropagate, "org.ops4j.pax.web.worker.name", config.getWorkerName());
        this.setProperty(toPropagate, "org.ops4j.pax.web.listening.addresses", config.getListeningAddresses());
        this.setProperty(toPropagate, "org.osgi.service.http.port", httpPort);
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", httpSecurePort);
        this.setProperty(toPropagate, "org.ops4j.pax.web.config.file", config.getConfigurationDir());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.format", config.getLogNCSAFormat());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.retaindays", config.getLogNCSARetainDays());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.append", config.isLogNCSAAppend());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.extended", config.isLogNCSAExtended());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.dispatch", config.isLogNCSADispatch());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.logtimezone", config.getLogNCSATimeZone());
        if (JspSupportUtils.jspSupportAvailable()) {
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.check.interval", config.getJspCheckInterval());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.debug.info", config.getJspClassDebugInfo());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.development", config.getJspDevelopment());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.enable.pooling", config.getJspEnablePooling());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.ie.classid", config.getJspIeClassId());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.java.encoding", config.getJspJavaEncoding());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.keep.generated", config.getJspKeepgenerated());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.log.verbosity.level", config.getJspLogVerbosityLevel());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.mapped.file", config.getJspMappedfile());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.scratch.dir", config.getJspScratchDir());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.tagpool.max.size", config.getJspTagpoolMaxSize());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.precompilation", config.getJspPrecompilation());
        }
        this.m_httpServiceFactoryProps = toPropagate;
    }

    private void setProperty(Hashtable<String, Object> properties, String name, Object value) {
        if (value != null) {
            if (value instanceof File) {
                properties.put(name, ((File)value).getAbsolutePath());
            } else if (value instanceof Object[]) {
                properties.put(name, Activator.join(",", (Object[])value));
            } else {
                properties.put(name, value.toString());
            }
        } else {
            properties.remove(name);
        }
    }

    private static String join(String token, Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < array.length - 1; ++x) {
            if (array[x] != null) {
                sb.append(array[x].toString());
            } else {
                sb.append("null");
            }
            sb.append(token);
        }
        sb.append(array[array.length - 1]);
        return sb.toString();
    }

    private class EventServiceCustomizer
    implements ServiceTrackerCustomizer {
        private EventServiceCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object eventService = Activator.this.bundleContext.getService(reference);
            if (eventService instanceof EventAdmin) {
                Activator.this.servletEventDispatcher.setEventAdminService(eventService);
            }
            return eventService;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            if (Activator.this.servletEventDispatcher != null) {
                Activator.this.servletEventDispatcher.setEventAdminService(null);
            }
            Activator.this.bundleContext.ungetService(reference);
        }
    }

    private class LogServiceCustomizer
    implements ServiceTrackerCustomizer {
        private LogServiceCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object logService = Activator.this.bundleContext.getService(reference);
            if (logService instanceof LogService) {
                Activator.this.servletEventDispatcher.setLogService(logService);
            }
            return logService;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            if (Activator.this.servletEventDispatcher != null) {
                Activator.this.servletEventDispatcher.setLogService(null);
            }
            Activator.this.bundleContext.ungetService(reference);
        }
    }

    private class DynamicsServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private DynamicsServiceTrackerCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            LOG.debug("Adding service for ServiceReference: {}", (Object)reference);
            ServerControllerFactory factory = (ServerControllerFactory)Activator.this.bundleContext.getService(reference);
            Activator.this.m_serverController = factory.createServerController(Activator.this.m_serverModel);
            Activator.this.m_serverControllerDefaultConfigured = false;
            if (ConfigAdminSupportUtils.configAdminSupportAvailable()) {
                Activator.this.createManagedService(Activator.this.bundleContext);
            }
            Activator.this.createHttpServiceFactory(Activator.this.bundleContext);
            return factory;
        }

        public void modifiedService(ServiceReference reference, Object service) {
            if (Activator.this.m_serverController != null) {
                Activator.this.m_serverController.stop();
            }
            Activator.this.m_serverController = null;
            Activator.this.m_serverControllerDefaultConfigured = false;
            if (Activator.this.m_httpServiceFactoryReg != null) {
                Activator.this.m_httpServiceFactoryReg.unregister();
            }
            Activator.this.m_httpServiceFactoryReg = null;
            ServerControllerFactory factory = (ServerControllerFactory)Activator.this.bundleContext.getService(reference);
            Activator.this.m_serverController = factory.createServerController(Activator.this.m_serverModel);
            if (ConfigAdminSupportUtils.configAdminSupportAvailable()) {
                Activator.this.createManagedService(Activator.this.bundleContext);
            }
            Activator.this.createHttpServiceFactory(Activator.this.bundleContext);
        }

        public void removedService(ServiceReference reference, Object service) {
            if (Activator.this.m_serverController != null) {
                Activator.this.m_serverController.stop();
            }
            Activator.this.m_serverController = null;
            Activator.this.m_serverControllerDefaultConfigured = false;
            if (Activator.this.m_httpServiceFactoryReg != null) {
                Activator.this.m_httpServiceFactoryReg.unregister();
            }
            Activator.this.m_httpServiceFactoryReg = null;
            if (Activator.this.bundleContext != null) {
                Activator.this.bundleContext.ungetService(reference);
            }
        }
    }
}

