/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.util.JspSupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
    private final PropertyResolver m_propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_propertyResolver = propertyResolver;
    }

    public Integer getHttpPort() {
        return this.getResolvedIntegerProperty("org.osgi.service.http.port");
    }

    public Boolean useNIO() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.useNIO");
    }

    public Boolean isClientAuthNeeded() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.ssl.clientauthneeded");
    }

    public Boolean isClientAuthWanted() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.ssl.clientauthwanted");
    }

    public Boolean isHttpEnabled() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.enabled");
    }

    public Integer getHttpSecurePort() {
        return this.getResolvedIntegerProperty("org.osgi.service.http.port.secure");
    }

    public Boolean isHttpSecureEnabled() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.secure.enabled");
    }

    public String getSslKeystore() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keystore");
    }

    public String getSslKeystoreType() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keystore.type");
    }

    public String getSslPassword() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.password");
    }

    public String getSslKeyPassword() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keypassword");
    }

    public File getTemporaryDirectory() {
        try {
            if (!this.contains("javax.servlet.context.tempdir")) {
                String tempDirPath = this.m_propertyResolver.get("javax.servlet.context.tempdir");
                File tempDir = tempDirPath.startsWith("file:") ? new File(new URI(tempDirPath)) : new File(tempDirPath);
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                return this.set("javax.servlet.context.tempdir", tempDir);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property javax.servlet.context.tempdir has failed");
        }
        return (File)this.get("javax.servlet.context.tempdir");
    }

    public File getConfigurationDir() {
        try {
            if (!this.contains("org.ops4j.pax.web.config.file")) {
                String serverConfigurationFileName = this.m_propertyResolver.get("org.ops4j.pax.web.config.file");
                File configurationFile = serverConfigurationFileName.startsWith("file:") ? new File(new URI(serverConfigurationFileName)) : new File(serverConfigurationFileName);
                if (!configurationFile.exists()) {
                    LOG.debug("Reading from configured path for the configuration property org.ops4j.pax.web.config.file has failed");
                }
                return this.set("org.ops4j.pax.web.config.file", configurationFile);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.config.file has failed");
        }
        return null;
    }

    public Integer getSessionTimeout() {
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.session.timeout");
    }

    public String getSessionCookie() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.cookie");
    }

    public String getSessionUrl() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.url");
    }

    public String getWorkerName() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.worker.name");
    }

    public String[] getListeningAddresses() {
        try {
            if (!this.contains("org.ops4j.pax.web.listening.addresses")) {
                String interfacesString = this.m_propertyResolver.get("org.ops4j.pax.web.listening.addresses");
                String[] interfaces = interfacesString == null ? new String[]{} : interfacesString.split(",");
                return this.set("org.ops4j.pax.web.listening.addresses", interfaces);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.listening.addresses has failed");
        }
        return (String[])this.get("org.ops4j.pax.web.listening.addresses");
    }

    public String getJspScratchDir() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.scratch.dir");
    }

    public Integer getJspCheckInterval() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.jsp.check.interval");
    }

    public Boolean getJspClassDebugInfo() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.debug.info");
    }

    public Boolean getJspDevelopment() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.development");
    }

    public Boolean getJspEnablePooling() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.enable.pooling");
    }

    public String getJspIeClassId() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.ie.classid");
    }

    public String getJspJavaEncoding() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.java.encoding");
    }

    public Boolean getJspKeepgenerated() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.keep.generated");
    }

    public String getJspLogVerbosityLevel() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.log.verbosity.level");
    }

    public Boolean getJspMappedfile() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.mapped.file");
    }

    public Integer getJspTagpoolMaxSize() {
        if (!JspSupportUtils.jspSupportAvailable()) {
            return null;
        }
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.jsp.tagpool.max.size");
    }

    public Boolean isLogNCSAFormatEnabled() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.enabled");
    }

    public String getLogNCSAFormat() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.format");
    }

    public String getLogNCSARetainDays() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.retaindays");
    }

    public Boolean isLogNCSAAppend() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.append");
    }

    public Boolean isLogNCSAExtended() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.extended");
    }

    public String getLogNCSATimeZone() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.logtimezone");
    }

    public String getLogNCSADirectory() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.directory");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "http enabled=" + this.isHttpEnabled() + ",http port=" + this.getHttpPort() + ",http secure enabled=" + this.isHttpSecureEnabled() + ",http secure port=" + this.getHttpSecurePort() + ",ssl keystore=" + this.getSslKeystore() + ",ssl keystoreType=" + this.getSslKeystoreType() + ",session timeout=" + this.getSessionTimeout() + ",session url=" + this.getSessionUrl() + ",session cookie=" + this.getSessionCookie() + ",worker name=" + this.getWorkerName() + ",listening addresses=" + Arrays.toString(this.getListeningAddresses()) + "}";
    }

    private String getResolvedStringProperty(String property) {
        try {
            if (!this.contains(property)) {
                return this.set(property, this.m_propertyResolver.get(property));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (String)this.get(property);
    }

    private Boolean getResolvedBooleanProperty(String property) {
        try {
            if (!this.contains(property)) {
                return this.set(property, Boolean.valueOf(this.m_propertyResolver.get(property)));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (Boolean)this.get(property);
    }

    private Integer getResolvedIntegerProperty(String property) {
        try {
            if (!this.contains(property)) {
                return this.set(property, Integer.valueOf(this.m_propertyResolver.get(property)));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (Integer)this.get(property);
    }
}

