/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.jsp.JspServletWrapper;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.internal.DefaultHttpContext;
import org.ops4j.pax.web.service.internal.DefaultSharedWebContainerContext;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.ops4j.pax.web.service.internal.WelcomeFilesFilter;
import org.ops4j.pax.web.service.internal.util.JspSupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerEvent;
import org.ops4j.pax.web.service.spi.ServerListener;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ResourceModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServiceModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpServiceStarted
implements StoppableHttpService {
    private static final Log LOG = LogFactory.getLog(HttpServiceStarted.class);
    private final Bundle m_bundle;
    private final ClassLoader m_bundleClassLoader;
    private final ServerController m_serverController;
    private final ServerModel m_serverModel;
    private final ServiceModel m_serviceModel;
    private final ServerListener m_serverListener;
    private static SharedWebContainerContext sharedWebContainerContext = new DefaultSharedWebContainerContext();

    HttpServiceStarted(Bundle bundle, ServerController serverController, ServerModel serverModel) {
        LOG.debug("Creating http service for: " + bundle);
        NullArgumentException.validateNotNull(bundle, "Bundle");
        NullArgumentException.validateNotNull(serverController, "Server controller");
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.m_bundle = bundle;
        this.m_bundleClassLoader = new BundleClassLoader(bundle);
        this.m_serverController = serverController;
        this.m_serverModel = serverModel;
        this.m_serviceModel = new ServiceModel();
        this.m_serverListener = new ServerListener(){

            public void stateChanged(ServerEvent event) {
                LOG.debug("Handling event: [" + (Object)((Object)event) + "]");
                if (event == ServerEvent.STARTED) {
                    for (ServletModel servletModel : HttpServiceStarted.this.m_serviceModel.getServletModels()) {
                        HttpServiceStarted.this.m_serverController.addServlet(servletModel);
                    }
                    for (Model model : HttpServiceStarted.this.m_serviceModel.getEventListenerModels()) {
                        HttpServiceStarted.this.m_serverController.addEventListener((EventListenerModel)model);
                    }
                    for (Model model : HttpServiceStarted.this.m_serviceModel.getFilterModels()) {
                        HttpServiceStarted.this.m_serverController.addFilter((FilterModel)model);
                    }
                    for (Model model : HttpServiceStarted.this.m_serviceModel.getErrorPageModels()) {
                        HttpServiceStarted.this.m_serverController.addErrorPage((ErrorPageModel)model);
                    }
                }
            }
        };
        this.m_serverController.addListener(this.m_serverListener);
    }

    @Override
    public synchronized void stop() {
        for (ServletModel servletModel : this.m_serviceModel.getServletModels()) {
            this.m_serverModel.removeServletModel(servletModel);
        }
        for (Model model : this.m_serviceModel.getFilterModels()) {
            this.m_serverModel.removeFilterModel((FilterModel)model);
        }
        for (Identity identity : this.m_serviceModel.getContextModels()) {
            this.m_serverController.removeContext(((ContextModel)identity).getHttpContext());
        }
        this.m_serverController.removeListener(this.m_serverListener);
        this.m_serverModel.deassociateHttpContexts(this.m_bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, alias, initParams);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.m_serverModel.addServletModel(model);
            serverSuccess = true;
            this.m_serviceModel.addServletModel(model);
            serviceSuccess = true;
            this.m_serverController.addServlet(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.m_serviceModel.removeServletModel(model);
                }
                if (serverSuccess) {
                    this.m_serverModel.removeServletModel(model);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        Servlet servlet = this.m_serverController.createResourceServlet(contextModel, alias, name);
        ResourceModel model = new ResourceModel(contextModel, servlet, alias, name);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            try {
                this.m_serverModel.addServletModel(model);
                serverSuccess = true;
            }
            catch (ServletException e) {
                // empty catch block
            }
            this.m_serviceModel.addServletModel(model);
            serviceSuccess = true;
            this.m_serverController.addServlet(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.m_serviceModel.removeServletModel(model);
                }
                if (serverSuccess) {
                    this.m_serverModel.removeServletModel(model);
                }
            }
        }
    }

    @Override
    public void unregister(String alias) {
        ServletModel model = this.m_serviceModel.getServletModelWithAlias(alias);
        if (model == null) {
            throw new IllegalArgumentException("Alias [" + alias + "] was never registered");
        }
        this.m_serverModel.removeServletModel(model);
        this.m_serviceModel.removeServletModel(model);
        this.m_serverController.removeServlet(model);
    }

    @Override
    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.m_bundle);
    }

    @Override
    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, null, urlPatterns, initParams, httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary initParams, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, servletName, urlPatterns, null, initParams);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            try {
                this.m_serverModel.addServletModel(model);
                serverSuccess = true;
            }
            catch (NamespaceException ignore) {
                // empty catch block
            }
            this.m_serviceModel.addServletModel(model);
            serviceSuccess = true;
            this.m_serverController.addServlet(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.m_serviceModel.removeServletModel(model);
                }
                if (serverSuccess) {
                    this.m_serverModel.removeServletModel(model);
                }
            }
        }
    }

    @Override
    public void unregisterServlet(Servlet servlet) {
        ServletModel model = this.m_serviceModel.removeServlet(servlet);
        if (model != null) {
            this.m_serverModel.removeServletModel(model);
            this.m_serverController.removeServlet(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        EventListenerModel model = new EventListenerModel(contextModel, listener);
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.m_serviceModel.addEventListenerModel(model);
            serviceSuccess = true;
            this.m_serverController.addEventListener(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.m_serviceModel.removeEventListener(listener);
            }
        }
    }

    @Override
    public void unregisterEventListener(EventListener listener) {
        EventListenerModel model = this.m_serviceModel.removeEventListener(listener);
        if (model != null) {
            this.m_serverController.removeEventListener(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFilter(Filter filter, String[] urlPatterns, String[] servletNames, Dictionary initParams, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        FilterModel model = new FilterModel(contextModel, filter, urlPatterns, servletNames, initParams);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.m_serverModel.addFilterModel(model);
            serverSuccess = true;
            this.m_serviceModel.addFilterModel(model);
            serviceSuccess = true;
            this.m_serverController.addFilter(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.m_serviceModel.removeFilter(filter);
                }
                if (serverSuccess) {
                    this.m_serverModel.removeFilterModel(model);
                }
            }
        }
    }

    @Override
    public void unregisterFilter(Filter filter) {
        FilterModel model = this.m_serviceModel.removeFilter(filter);
        if (model != null) {
            this.m_serverModel.removeFilterModel(model);
            this.m_serverController.removeFilter(model);
        }
    }

    @Override
    public void setContextParam(Dictionary params, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        if (!this.m_serviceModel.canBeConfigured()) {
            throw new IllegalStateException("Http context already used. Context params can be set only before first usage");
        }
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        contextModel.setContextParams(params);
        this.m_serviceModel.addContextModel(contextModel);
    }

    @Override
    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        if (!this.m_serviceModel.canBeConfigured()) {
            throw new IllegalStateException("Http context already used. Session timeout can be set only before first usage");
        }
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        contextModel.setSessionTimeout(minutes);
        this.m_serviceModel.addContextModel(contextModel);
    }

    @Override
    public void registerJsps(String[] urlPatterns, HttpContext httpContext) {
        if (!JspSupportUtils.jspSupportAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        ContextModel contextModel = this.m_serviceModel.getContextModel(httpContext);
        if (contextModel != null && contextModel.getJspServlet() != null) {
            LOG.debug("JSP support already enabled");
            return;
        }
        JspServletWrapper jspServlet = new JspServletWrapper(this.m_bundle);
        try {
            String[] stringArray;
            File tempDir;
            Configuration configuration = this.m_serverController.getConfiguration();
            String scratchDir = configuration.getJspScratchDir();
            if (scratchDir == null) {
                scratchDir = configuration.getTemporaryDirectory().toString();
            }
            if (!(tempDir = new File(scratchDir + File.separatorChar + contextModel.getContextName())).exists()) {
                tempDir.mkdirs();
            }
            scratchDir = tempDir.toString();
            Integer jspCheckInterval = configuration.getJspCheckInterval();
            Boolean jspClassDebugInfo = configuration.getJspClassDebugInfo();
            Boolean jspDevelopment = configuration.getJspDevelopment();
            Boolean jspEnablePooling = configuration.getJspEnablePooling();
            String jspIeClassId = configuration.getJspIeClassId();
            String jspJavaEncoding = configuration.getJspJavaEncoding();
            Boolean jspKeepgenerated = configuration.getJspKeepgenerated();
            String jspLogVerbosityLevel = configuration.getJspLogVerbosityLevel();
            Boolean jspMappedfile = configuration.getJspMappedfile();
            Integer jspTagpoolMaxSize = configuration.getJspTagpoolMaxSize();
            Hashtable<String, String> initParams = new Hashtable<String, String>();
            ((Dictionary)initParams).put("checkInterval", jspCheckInterval.toString());
            ((Dictionary)initParams).put("classdebuginfo", jspClassDebugInfo.toString());
            ((Dictionary)initParams).put("development", jspDevelopment.toString());
            ((Dictionary)initParams).put("enablePooling", jspEnablePooling.toString());
            ((Dictionary)initParams).put("ieClassId", jspIeClassId);
            ((Dictionary)initParams).put("javaEncoding", jspJavaEncoding);
            ((Dictionary)initParams).put("keepgenerated", jspKeepgenerated.toString());
            ((Dictionary)initParams).put("logVerbosityLevel", jspLogVerbosityLevel);
            ((Dictionary)initParams).put("mappedfile", jspMappedfile.toString());
            ((Dictionary)initParams).put("scratchdir", scratchDir);
            ((Dictionary)initParams).put("tagpoolMaxSize", jspTagpoolMaxSize.toString());
            if (urlPatterns == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*.jsp";
            } else {
                stringArray = urlPatterns;
            }
            this.registerServlet((Servlet)jspServlet, stringArray, initParams, httpContext);
            if (contextModel == null) {
                contextModel = this.m_serviceModel.getContextModel(httpContext);
            }
            contextModel.setJspServlet((Servlet)jspServlet);
        }
        catch (ServletException ignore) {
            LOG.error("Internal error. Please report.", ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterJsps(HttpContext httpContext) {
        if (!JspSupportUtils.jspSupportAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.m_serviceModel.getContextModel(httpContext);
        if (contextModel == null || contextModel.getJspServlet() == null) {
            throw new IllegalArgumentException("Jsp suppport is not enabled for http context [" + httpContext + "]");
        }
        try {
            this.unregisterServlet(contextModel.getJspServlet());
        }
        finally {
            contextModel.setJspServlet(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ErrorPageModel model = new ErrorPageModel(contextModel, error, location);
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.m_serviceModel.addErrorPageModel(model);
            serviceSuccess = true;
            this.m_serverController.addErrorPage(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.m_serviceModel.removeErrorPage(error, contextModel);
            }
        }
    }

    @Override
    public void unregisterErrorPage(String error, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ErrorPageModel model = this.m_serviceModel.removeErrorPage(error, this.m_serviceModel.getContextModel(httpContext));
        if (model != null) {
            this.m_serverController.removeErrorPage(model);
        }
    }

    @Override
    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        ContextModel contextModel = this.m_serviceModel.getContextModel(httpContext);
        if (contextModel != null && contextModel.getWelcomeFilesFilter() != null) {
            throw new IllegalStateException("Welcome files already registered for this context");
        }
        WelcomeFilesFilter welcomeFilesFilter = new WelcomeFilesFilter(welcomeFiles, redirect);
        try {
            this.registerFilter(welcomeFilesFilter, new String[]{"/*"}, null, null, httpContext);
            if (contextModel == null) {
                contextModel = this.m_serviceModel.getContextModel(httpContext);
            }
            contextModel.setWelcomeFilesFilter(welcomeFilesFilter);
        }
        catch (Exception ignore) {
            LOG.error("Internal error. Please report.", ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterWelcomeFiles(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.m_serviceModel.getContextModel(httpContext);
        if (contextModel == null || contextModel.getWelcomeFilesFilter() == null) {
            throw new IllegalArgumentException("Welcome files are not registered for http context [" + httpContext + "]");
        }
        try {
            this.unregisterFilter(contextModel.getWelcomeFilesFilter());
        }
        finally {
            contextModel.setWelcomeFilesFilter(null);
        }
    }

    @Override
    public void registerLoginConfig(String authMethod, String realmName, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        if (!this.m_serviceModel.canBeConfigured()) {
            throw new IllegalStateException("Http context already used. Session timeout can be set only before first usage");
        }
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        contextModel.setAuthMethod(authMethod);
        contextModel.setRealmName(realmName);
        this.m_serviceModel.addContextModel(contextModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLoginConfig(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.m_serviceModel.getContextModel(httpContext);
        if (contextModel == null || contextModel.getAuthMethod() == null || contextModel.getRealmName() == null) {
            throw new IllegalArgumentException("Security Realm and authorization method are not registered for http context [" + httpContext + "]");
        }
    }

    @Override
    public void registerConstraintMapping(String constraintName, String url, String mapping, String dataConstraint, boolean authentication, List<String> roles, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        SecurityConstraintMappingModel secConstraintMapModel = new SecurityConstraintMappingModel(contextModel, constraintName, mapping, url, dataConstraint, authentication, roles);
        this.m_serviceModel.addSecurityConstraintMappingModel(secConstraintMapModel);
        this.m_serverController.addSecurityConstraintMapping(secConstraintMapModel);
    }

    @Override
    public void unregisterConstraintMapping(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
    }

    private ContextModel getOrCreateContext(HttpContext httpContext) {
        HttpContext context = httpContext;
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.m_serverModel.associateHttpContext(context, this.m_bundle, httpContext instanceof SharedWebContainerContext);
        ContextModel contextModel = this.m_serviceModel.getContextModel(context);
        if (contextModel == null) {
            contextModel = new ContextModel(context, this.m_bundle, this.m_bundleClassLoader);
        }
        return contextModel;
    }

    @Override
    public SharedWebContainerContext getDefaultSharedHttpContext() {
        return sharedWebContainerContext;
    }
}

