/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.CloseState;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ClientSession
extends HTTP2Session {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2ClientSession.class);

    public HTTP2ClientSession(Scheduler scheduler, EndPoint endPoint, Generator generator, Session.Listener listener, FlowControlStrategy flowControl) {
        super(scheduler, endPoint, generator, listener, flowControl, 1);
    }

    @Override
    public void onHeaders(HeadersFrame frame) {
        int streamId;
        IStream stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", (Object)frame);
        }
        if ((stream = this.getStream(streamId = frame.getStreamId())) != null) {
            MetaData metaData = frame.getMetaData();
            if (metaData.isRequest()) {
                this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "invalid_response");
            } else {
                stream.process(frame, Callback.NOOP);
                if (stream.updateClose(frame.isEndStream(), CloseState.Event.RECEIVED)) {
                    this.removeStream(stream);
                }
                this.notifyHeaders(stream, frame);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream #{} not found", (Object)streamId);
            }
            if (HTTP2ClientSession.isClientStream(streamId)) {
                if (!this.isLocalStreamClosed(streamId)) {
                    this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unexpected_headers_frame");
                }
            } else if (!this.isRemoteStreamClosed(streamId)) {
                this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unexpected_headers_frame");
            }
        }
    }

    @Override
    public void onPushPromise(PushPromiseFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", (Object)frame);
        }
        int streamId = frame.getStreamId();
        int pushStreamId = frame.getPromisedStreamId();
        IStream stream = this.getStream(streamId);
        if (stream == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring {}, stream #{} not found", (Object)frame, (Object)streamId);
            }
        } else {
            IStream pushStream = this.createRemoteStream(pushStreamId, frame.getMetaData());
            if (pushStream != null) {
                pushStream.process(frame, Callback.NOOP);
                Stream.Listener listener = this.notifyPush(stream, pushStream, frame);
                pushStream.setListener(listener);
            }
        }
    }

    private Stream.Listener notifyPush(IStream stream, IStream pushStream, PushPromiseFrame frame) {
        Stream.Listener listener = stream.getListener();
        if (listener == null) {
            return null;
        }
        try {
            return listener.onPush(pushStream, frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
            return null;
        }
    }
}

