/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.jetty.internal.web.JettyResourceServlet;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedServlet;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public class PaxWebServletHolder
extends ServletHolder {
    private final ServletModel servletModel;
    private final OsgiContextModel osgiContextModel;
    private ServletMapping mapping;
    private ServiceReference<Servlet> servletReference;
    private final OsgiServletContext osgiServletContext;
    private final OsgiScopedServletContext servletContext;
    private ServiceObjects<Servlet> serviceObjects;
    private final WebContainerContext webContainerContext;
    private boolean is404;
    private boolean whiteboardTCCL;

    PaxWebServletHolder(String name, Servlet servlet, boolean is404) {
        super(name, servlet);
        this.servletModel = null;
        this.osgiContextModel = null;
        this.osgiServletContext = null;
        this.servletContext = null;
        this.webContainerContext = null;
        this.is404 = is404;
    }

    public PaxWebServletHolder(ServletModel servletModel, OsgiContextModel osgiContextModel, OsgiServletContext osgiServletContext) {
        this.servletModel = servletModel;
        this.osgiContextModel = osgiContextModel;
        this.osgiServletContext = osgiServletContext;
        this.setName(servletModel.getName());
        if (servletModel.getServletClass() != null) {
            this.setHeldClass(servletModel.getServletClass());
        } else if (servletModel.getServlet() != null) {
            this.setServlet(servletModel.getServlet());
            this.setHeldClass(servletModel.getServlet().getClass());
        } else {
            this.servletReference = servletModel.getElementReference();
        }
        this.setInitParameters(servletModel.getInitParams());
        this.setAsyncSupported(servletModel.getAsyncSupported() != null && servletModel.getAsyncSupported() != false);
        if (servletModel.getLoadOnStartup() != null) {
            this.setInitOrder(servletModel.getLoadOnStartup());
        }
        this.getRegistration().setMultipartConfig(servletModel.getMultipartConfigElement());
        this.servletContext = new OsgiScopedServletContext(this.osgiServletContext, servletModel.getRegisteringBundle());
        this.webContainerContext = this.servletContext.getResolvedWebContainerContext();
    }

    public ServletModel getServletModel() {
        return this.servletModel;
    }

    public Bundle getRegisteringBundle() {
        return this.servletModel.getRegisteringBundle();
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContextModel;
    }

    public ServletContext getOsgiServletContext() {
        return this.servletContext;
    }

    public WebContainerContext getWebContainerContext() {
        return this.webContainerContext;
    }

    public boolean is404() {
        return this.is404;
    }

    @Override
    public void doStart() throws Exception {
        if (this.servletReference != null) {
            this.setHeldClass(Servlet.class);
        } else if (this.servletModel != null && this.servletModel.getElementSupplier() != null) {
            this.setInstance((Servlet)this.servletModel.getElementSupplier().get());
        }
        super.doStart();
    }

    @Override
    protected synchronized Servlet getInstance() {
        BundleContext context;
        Servlet instance = (Servlet)super.getInstance();
        if (instance == null && this.servletReference != null && (context = this.servletModel.getRegisteringBundle().getBundleContext()) != null) {
            if (!this.servletModel.isPrototype()) {
                instance = (Servlet)context.getService(this.servletReference);
            } else {
                this.serviceObjects = context.getServiceObjects(this.servletReference);
                instance = (Servlet)this.serviceObjects.getService();
            }
        }
        if (instance == null && this.servletModel.getElementSupplier() != null) {
            instance = (Servlet)this.servletModel.getElementSupplier().get();
        }
        if (instance != null && this.servletModel != null && this.servletModel.isResourceServlet()) {
            ((JettyResourceServlet)instance).setWelcomeFiles(this.osgiServletContext.getWelcomeFiles());
            ((JettyResourceServlet)instance).setWelcomeFilesRedirect(this.osgiServletContext.isWelcomeFilesRedirect());
        }
        if (instance == null) {
            this.servletModel.setDtoFailureCode(5);
        }
        return instance == null ? null : new OsgiInitializedServlet(instance, this.servletContext, this.whiteboardTCCL);
    }

    @Override
    public void destroyInstance(Object o) {
        super.destroyInstance(o);
        if (this.servletModel != null && this.servletReference != null) {
            if (!this.servletModel.isPrototype()) {
                BundleContext context = this.servletModel.getRegisteringBundle().getBundleContext();
                if (context != null) {
                    context.ungetService(this.servletReference);
                }
            } else {
                Servlet realServlet = (Servlet)o;
                if (realServlet instanceof ServletHolder.Wrapper) {
                    realServlet = ((ServletHolder.Wrapper)realServlet).getWrapped();
                }
                if (realServlet instanceof OsgiInitializedServlet) {
                    realServlet = ((OsgiInitializedServlet)realServlet).getDelegate();
                }
                this.serviceObjects.ungetService((Object)realServlet);
            }
        }
        if (this.servletModel != null && this.servletModel.getRegisteringBundle() != null) {
            this.servletContext.releaseWebContainerContext(this.servletModel.getRegisteringBundle());
        }
    }

    @Override
    protected Servlet newInstance() throws Exception {
        return new OsgiInitializedServlet(super.newInstance(), this.servletContext, this.whiteboardTCCL);
    }

    @Override
    public void prepare(Request baseRequest, ServletRequest request, ServletResponse response) throws ServletException, UnavailableException {
        super.prepare(baseRequest, request, response);
    }

    public void setMapping(ServletMapping mapping) {
        this.mapping = mapping;
    }

    public ServletMapping getMapping() {
        return this.mapping;
    }

    public void setWhiteboardTCCL(boolean whiteboardTCCL) {
        this.whiteboardTCCL = whiteboardTCCL;
    }
}

