/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.bindings.StandardDeployer;
import org.eclipse.jetty.deploy.bindings.StandardStarter;
import org.eclipse.jetty.deploy.bindings.StandardStopper;
import org.eclipse.jetty.deploy.bindings.StandardUndeployer;
import org.eclipse.jetty.deploy.graph.Edge;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.deploy.graph.Path;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Deployment Manager")
public class DeploymentManager
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentManager.class);
    private final AutoLock _lock = new AutoLock();
    private MultiException _onStartupErrors;
    private final List<AppProvider> _providers = new ArrayList<AppProvider>();
    private final AppLifeCycle _lifecycle = new AppLifeCycle();
    private final Queue<AppEntry> _apps = new ConcurrentLinkedQueue<AppEntry>();
    private AttributesMap _contextAttributes = new AttributesMap();
    private ContextHandlerCollection _contexts;
    private boolean _useStandardBindings = true;
    private String _defaultLifeCycleGoal = "started";

    public void addApp(App app) {
        LOG.debug("Deployable added: {}", (Object)app.getOriginId());
        AppEntry entry = new AppEntry();
        entry.app = app;
        entry.setLifeCycleNode(this._lifecycle.getNodeByName("undeployed"));
        this._apps.add(entry);
        if (this.isRunning() && this._defaultLifeCycleGoal != null) {
            this.requestAppGoal(entry, this._defaultLifeCycleGoal);
        }
    }

    public void setAppProviders(Collection<AppProvider> providers) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._providers.clear();
        this.removeBeans();
        for (AppProvider provider : providers) {
            if (!this._providers.add(provider)) continue;
            this.addBean(provider, true);
        }
    }

    public Collection<AppProvider> getAppProviders() {
        return Collections.unmodifiableList(this._providers);
    }

    public void addAppProvider(AppProvider provider) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._providers.add(provider);
        this.addBean(provider, true);
    }

    public void setLifeCycleBindings(Collection<AppLifeCycle.Binding> bindings) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        for (AppLifeCycle.Binding b : this._lifecycle.getBindings()) {
            this._lifecycle.removeBinding(b);
        }
        for (AppLifeCycle.Binding b : bindings) {
            this._lifecycle.addBinding(b);
        }
    }

    public Collection<AppLifeCycle.Binding> getLifeCycleBindings() {
        return Collections.unmodifiableSet(this._lifecycle.getBindings());
    }

    public void addLifeCycleBinding(AppLifeCycle.Binding binding) {
        this._lifecycle.addBinding(binding);
    }

    public void insertLifeCycleNode(String existingFromNodeName, String existingToNodeName, String insertedNodeName) {
        Node fromNode = this._lifecycle.getNodeByName(existingFromNodeName);
        Node toNode = this._lifecycle.getNodeByName(existingToNodeName);
        Edge edge = new Edge(fromNode, toNode);
        this._lifecycle.insertNode(edge, insertedNodeName);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getContexts() == null) {
            throw new IllegalStateException("No Contexts");
        }
        if (this._useStandardBindings) {
            LOG.debug("DeploymentManager using standard bindings");
            this.addLifeCycleBinding(new StandardDeployer());
            this.addLifeCycleBinding(new StandardStarter());
            this.addLifeCycleBinding(new StandardStopper());
            this.addLifeCycleBinding(new StandardUndeployer());
        }
        for (AppProvider provider : this._providers) {
            this.startAppProvider(provider);
        }
        try (AutoLock l = this._lock.lock();){
            if (this._onStartupErrors != null) {
                this._onStartupErrors.ifExceptionThrow();
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        for (AppProvider provider : this._providers) {
            try {
                provider.stop();
            }
            catch (Exception e) {
                LOG.warn("Unable to start AppProvider", (Throwable)e);
            }
        }
        super.doStop();
    }

    private AppEntry findAppByOriginId(String originId) {
        if (originId == null) {
            return null;
        }
        for (AppEntry entry : this._apps) {
            if (!originId.equals(entry.app.getOriginId())) continue;
            return entry;
        }
        return null;
    }

    public App getAppByOriginId(String originId) {
        AppEntry entry = this.findAppByOriginId(originId);
        if (entry == null) {
            return null;
        }
        return entry.app;
    }

    public Collection<AppEntry> getAppEntries() {
        return Collections.unmodifiableCollection(this._apps);
    }

    public Collection<App> getApps() {
        ArrayList<App> ret = new ArrayList<App>();
        for (AppEntry entry : this._apps) {
            ret.add(entry.app);
        }
        return ret;
    }

    public Collection<App> getApps(Node node) {
        Objects.requireNonNull(node);
        ArrayList<App> ret = new ArrayList<App>();
        for (AppEntry entry : this._apps) {
            if (!node.equals(entry.lifecyleNode)) continue;
            ret.add(entry.app);
        }
        return ret;
    }

    public Collection<App> getApps(String nodeName) {
        return this.getApps(this._lifecycle.getNodeByName(nodeName));
    }

    public List<App> getAppsWithSameContext(App app) {
        ArrayList<App> ret = new ArrayList<App>();
        if (app == null) {
            return ret;
        }
        String contextId = app.getContextPath();
        if (contextId == null) {
            return ret;
        }
        for (AppEntry entry : this._apps) {
            if (entry.app.equals(app) || !contextId.equals(entry.app.getContextPath())) continue;
            ret.add(entry.app);
        }
        return ret;
    }

    public Object getContextAttribute(String name) {
        return this._contextAttributes.getAttribute(name);
    }

    public AttributesMap getContextAttributes() {
        return this._contextAttributes;
    }

    @ManagedAttribute(value="Deployed Contexts")
    public ContextHandlerCollection getContexts() {
        return this._contexts;
    }

    public String getDefaultLifeCycleGoal() {
        return this._defaultLifeCycleGoal;
    }

    public AppLifeCycle getLifeCycle() {
        return this._lifecycle;
    }

    public Server getServer() {
        if (this._contexts == null) {
            return null;
        }
        return this._contexts.getServer();
    }

    public void removeApp(App app) {
        Iterator it = this._apps.iterator();
        while (it.hasNext()) {
            AppEntry entry = (AppEntry)it.next();
            if (!entry.app.equals(app)) continue;
            if (!"undeployed".equals(entry.lifecyleNode.getName())) {
                this.requestAppGoal(entry.app, "undeployed");
            }
            it.remove();
            LOG.debug("Deployable removed: {}", (Object)entry.app);
        }
    }

    public void removeAppProvider(AppProvider provider) {
        if (this._providers.remove(provider)) {
            this.removeBean(provider);
        }
        try {
            provider.stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to stop Provider", (Throwable)e);
        }
    }

    public void removeContextAttribute(String name) {
        this._contextAttributes.removeAttribute(name);
    }

    public void requestAppGoal(App app, String nodeName) {
        AppEntry appentry = this.findAppByOriginId(app.getOriginId());
        if (appentry == null) {
            throw new IllegalStateException("App not being tracked by Deployment Manager: " + String.valueOf(app));
        }
        this.requestAppGoal(appentry, nodeName);
    }

    private void requestAppGoal(AppEntry appentry, String nodeName) {
        block8: {
            Node destinationNode = this._lifecycle.getNodeByName(nodeName);
            if (destinationNode == null) {
                throw new IllegalStateException("Node not present in Deployment Manager: " + nodeName);
            }
            Path path = this._lifecycle.getPath(appentry.lifecyleNode, destinationNode);
            if (path.isEmpty()) {
                return;
            }
            try {
                Iterator<Node> it = path.getNodes().iterator();
                if (it.hasNext()) {
                    it.next();
                    while (it.hasNext()) {
                        Node node = it.next();
                        LOG.debug("Executing Node {}", (Object)node);
                        this._lifecycle.runBindings(node, appentry.app, this);
                        appentry.setLifeCycleNode(node);
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn("Unable to reach node goal: {}", (Object)nodeName, (Object)t);
                Node failed = this._lifecycle.getNodeByName("failed");
                appentry.setLifeCycleNode(failed);
                try {
                    this._lifecycle.runBindings(failed, appentry.app, this);
                }
                catch (Throwable ignore) {
                    LOG.trace("IGNORED", ignore);
                }
                if (!this.isStarting()) break block8;
                this.addOnStartupError(t);
            }
        }
    }

    private void addOnStartupError(Throwable cause) {
        try (AutoLock l = this._lock.lock();){
            if (this._onStartupErrors == null) {
                this._onStartupErrors = new MultiException();
            }
            this._onStartupErrors.add(cause);
        }
    }

    @ManagedOperation(value="request the app to be moved to the specified lifecycle node", impact="ACTION")
    public void requestAppGoal(@Name(value="appId") String appId, @Name(value="nodeName") String nodeName) {
        AppEntry appentry = this.findAppByOriginId(appId);
        if (appentry == null) {
            throw new IllegalStateException("App not being tracked by Deployment Manager: " + appId);
        }
        this.requestAppGoal(appentry, nodeName);
    }

    public void setContextAttribute(String name, Object value) {
        this._contextAttributes.setAttribute(name, value);
    }

    public void setContextAttributes(AttributesMap contextAttributes) {
        this._contextAttributes = contextAttributes;
    }

    public void setContexts(ContextHandlerCollection contexts) {
        this._contexts = contexts;
    }

    public void setDefaultLifeCycleGoal(String defaultLifeCycleState) {
        this._defaultLifeCycleGoal = defaultLifeCycleState;
    }

    private void startAppProvider(AppProvider provider) {
        try {
            provider.setDeploymentManager(this);
            provider.start();
        }
        catch (Exception e) {
            LOG.warn("Unable to start AppProvider", (Throwable)e);
        }
    }

    public void undeployAll() {
        LOG.debug("Undeploy All");
        for (AppEntry appentry : this._apps) {
            this.requestAppGoal(appentry, "undeployed");
        }
    }

    public boolean isUseStandardBindings() {
        return this._useStandardBindings;
    }

    public void setUseStandardBindings(boolean useStandardBindings) {
        this._useStandardBindings = useStandardBindings;
    }

    public Collection<Node> getNodes() {
        return this._lifecycle.getNodes();
    }

    public void scope(XmlConfiguration xmlc, Resource webapp) throws IOException {
        xmlc.setJettyStandardIdsAndProperties(this.getServer(), webapp);
    }

    public class AppEntry {
        private int version;
        private App app;
        private Node lifecyleNode;
        private Map<Node, Long> stateTimestamps = new HashMap<Node, Long>();

        public App getApp() {
            return this.app;
        }

        public Node getLifecyleNode() {
            return this.lifecyleNode;
        }

        public Map<Node, Long> getStateTimestamps() {
            return this.stateTimestamps;
        }

        public int getVersion() {
            return this.version;
        }

        void setLifeCycleNode(Node node) {
            this.lifecyleNode = node;
            this.stateTimestamps.put(node, System.currentTimeMillis());
        }
    }
}

