/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.internal.DefaultHttpContext;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

class WebContainerContextWrapper
extends DefaultHttpContext {
    private final HttpContext httpContext;

    WebContainerContextWrapper(Bundle bundle, HttpContext httpContext) {
        super(bundle, WebContainerContext.DefaultContextIds.CUSTOM.getValue());
        NullArgumentException.validateNotNull(httpContext, "HttpContext");
        this.httpContext = httpContext;
    }

    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.httpContext.handleSecurity(request, response);
    }

    @Override
    public URL getResource(String name) {
        return this.httpContext.getResource(name);
    }

    @Override
    public String getMimeType(String name) {
        return this.httpContext.getMimeType(name);
    }

    @Override
    public String toString() {
        return "DefaultHttpContext [bundle=" + this.bundle + ", contextID=" + this.contextID + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = 31 * result + (this.contextID == null ? 0 : this.contextID.hashCode());
        result = 31 * result + (this.httpContext == null ? 0 : this.httpContext.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof WebContainerContextWrapper)) {
            return false;
        }
        WebContainerContextWrapper other = (WebContainerContextWrapper)obj;
        if (this.bundle == null ? other.bundle != null : !this.bundle.equals(other.bundle)) {
            return false;
        }
        if (this.contextID == null ? other.contextID != null : !this.contextID.equals(other.contextID)) {
            return false;
        }
        return !(this.httpContext == null ? other.httpContext != null : !this.httpContext.equals(other.httpContext));
    }
}

