/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.ops4j.lang.NullArgumentException;

public class MavenRepositoryURL {
    private static final Logger LOG = LoggerFactory.getLogger(MavenRepositoryURL.class);
    private final String m_id;
    private final URI m_repositoryURI;
    private final String m_username;
    private final char[] m_password;
    private final File m_file;
    private final boolean m_releasesEnabled;
    private final String m_releasesUpdatePolicy;
    private final String m_releasesChecksumPolicy;
    private final boolean m_snapshotsEnabled;
    private final String m_snapshotsUpdatePolicy;
    private final String m_snapshotsChecksumPolicy;
    private final boolean m_multi;
    private final boolean m_split;
    private final String m_splitLocalPrefix;
    private final String m_splitRemotePrefix;
    private final boolean m_splitLocal;
    private final boolean m_splitRemote;
    private final String m_splitReleasesPrefix;
    private final String m_splitSnapshotsPrefix;
    private final boolean m_splitRemoteRepository;
    private final boolean m_splitRemoteRepositoryLast;

    public MavenRepositoryURL(String repositorySpec) throws MalformedURLException {
        NullArgumentException.validateNotEmpty(repositorySpec, true, "Repository spec");
        String[] segments = repositorySpec.split("@");
        StringBuilder urlBuilder = new StringBuilder();
        boolean snapshotEnabled = false;
        boolean releasesEnabled = true;
        boolean multi = false;
        Object name = null;
        String update = null;
        String updateReleases = null;
        String updateSnapshots = null;
        String checksum = null;
        String checksumReleases = null;
        String checksumSnapshots = null;
        boolean split = false;
        boolean splitLocal = false;
        boolean splitRemote = false;
        boolean splitRemoteRepository = false;
        boolean splitRemoteRepositoryLast = false;
        String splitLocalPrefix = "installed";
        String splitRemotePrefix = "cached";
        String splitReleasesPrefix = "releases";
        String splitSnapshotsPrefix = "snapshots";
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i].trim();
            if (segment.equalsIgnoreCase("snapshots")) {
                snapshotEnabled = true;
                continue;
            }
            if (segment.equalsIgnoreCase("noreleases")) {
                releasesEnabled = false;
                continue;
            }
            if (segment.equalsIgnoreCase("multi")) {
                multi = true;
                continue;
            }
            if (segment.equalsIgnoreCase("split")) {
                split = true;
                continue;
            }
            if (segment.equalsIgnoreCase("splitLocal")) {
                splitLocal = true;
                continue;
            }
            if (segment.equalsIgnoreCase("splitRemote")) {
                splitRemote = true;
                continue;
            }
            if (segment.equalsIgnoreCase("splitRemoteRepository")) {
                splitRemoteRepository = true;
                continue;
            }
            if (segment.equalsIgnoreCase("splitRemoteRepositoryLast")) {
                splitRemoteRepositoryLast = true;
                continue;
            }
            if (segment.startsWith("id=")) {
                try {
                    name = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("releasesUpdate=")) {
                try {
                    updateReleases = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("snapshotsUpdate=")) {
                try {
                    updateSnapshots = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("update=")) {
                try {
                    update = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("releasesChecksum=")) {
                try {
                    checksumReleases = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("snapshotsChecksum=")) {
                try {
                    checksumSnapshots = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("checksum=")) {
                try {
                    checksum = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("splitLocalPrefix=")) {
                try {
                    splitLocalPrefix = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("splitRemotePrefix=")) {
                try {
                    splitRemotePrefix = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("splitReleasesPrefix=")) {
                try {
                    splitReleasesPrefix = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("splitSnapshotsPrefix=")) {
                try {
                    splitSnapshotsPrefix = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (i > 0) {
                urlBuilder.append("@");
            }
            urlBuilder.append(segments[i]);
        }
        Object spec = urlBuilder.toString().trim();
        spec = ((String)spec).replaceAll("\\\\", "/");
        if (!((String)(spec = ((String)spec).replaceAll("%5C", "/"))).endsWith("/")) {
            spec = (String)spec + "/";
        }
        this.m_repositoryURI = URI.create((String)spec);
        String credentials = this.m_repositoryURI.getRawUserInfo();
        if (credentials != null) {
            LOG.warn("Repository spec \"{}\" contains user information. It is recommended to specify server credentials in external settings.xml file.", spec);
            int colon = credentials.indexOf(58);
            if (colon != -1 && credentials.indexOf(58, colon + 1) != -1) {
                LOG.warn("Multiple ':' separators found in user info part of {}. Can't determine user credential. Please encode non-separator ':' using '%3A'.", spec);
                this.m_username = null;
                this.m_password = null;
            } else {
                String password;
                String username;
                if (colon != -1) {
                    username = credentials.substring(0, colon);
                    password = credentials.substring(colon + 1);
                } else {
                    username = credentials;
                    password = null;
                }
                this.m_username = URLDecoder.decode(username, StandardCharsets.UTF_8);
                this.m_password = (char[])(password != null ? URLDecoder.decode(password, StandardCharsets.UTF_8).toCharArray() : null);
            }
        } else {
            this.m_username = null;
            this.m_password = null;
        }
        this.m_snapshotsEnabled = snapshotEnabled;
        this.m_releasesEnabled = releasesEnabled;
        this.m_multi = multi;
        if (name == null) {
            String warn = "Repository spec " + (String)spec + " does not contain an identifier. Give your repository a name, for example: " + repositorySpec + "@id=MyName";
            LOG.warn(warn);
            name = "repo_" + ((String)spec).hashCode();
        }
        this.m_id = name;
        this.m_releasesUpdatePolicy = updateReleases != null ? updateReleases : update;
        this.m_snapshotsUpdatePolicy = updateSnapshots != null ? updateSnapshots : update;
        this.m_releasesChecksumPolicy = checksumReleases != null ? checksumReleases : checksum;
        this.m_snapshotsChecksumPolicy = checksumSnapshots != null ? checksumSnapshots : checksum;
        this.m_split = split;
        this.m_splitLocal = splitLocal;
        this.m_splitRemote = splitRemote;
        this.m_splitRemoteRepository = splitRemoteRepository;
        this.m_splitRemoteRepositoryLast = splitRemoteRepositoryLast;
        this.m_splitLocalPrefix = splitLocalPrefix;
        this.m_splitRemotePrefix = splitRemotePrefix;
        this.m_splitReleasesPrefix = splitReleasesPrefix;
        this.m_splitSnapshotsPrefix = splitSnapshotsPrefix;
        if (this.m_repositoryURI.getScheme().equals("file")) {
            try {
                spec = ((String)spec).replaceAll("\\\\", "/");
                spec = ((String)spec).replaceAll(" ", "%20");
                URI uri = new URI((String)spec);
                String path = uri.getPath();
                if (path == null) {
                    path = uri.getSchemeSpecificPart();
                }
                this.m_file = new File(path);
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
        } else {
            this.m_file = null;
        }
    }

    public MavenRepositoryURL(MavenRepositoryURL parent, File child) {
        if (parent.getFile() == null) {
            throw new IllegalArgumentException("Can't create child MavenRepositoryURL which is not a file (parent: " + String.valueOf(parent) + ")");
        }
        if (!parent.getFile().equals(child.getParentFile())) {
            throw new IllegalArgumentException(String.valueOf(child) + " is not a subdirectory of " + String.valueOf(parent));
        }
        this.m_id = parent.getId() + "/" + child.getName();
        this.m_repositoryURI = child.toURI();
        this.m_username = parent.m_username;
        this.m_password = parent.m_password;
        this.m_file = child;
        this.m_releasesEnabled = parent.m_releasesEnabled;
        this.m_releasesUpdatePolicy = parent.m_releasesUpdatePolicy;
        this.m_releasesChecksumPolicy = parent.m_releasesChecksumPolicy;
        this.m_snapshotsEnabled = parent.m_snapshotsEnabled;
        this.m_snapshotsUpdatePolicy = parent.m_snapshotsUpdatePolicy;
        this.m_snapshotsChecksumPolicy = parent.m_snapshotsChecksumPolicy;
        this.m_multi = false;
        this.m_split = parent.m_split;
        this.m_splitLocalPrefix = parent.m_splitLocalPrefix;
        this.m_splitRemotePrefix = parent.m_splitRemotePrefix;
        this.m_splitLocal = parent.m_splitLocal;
        this.m_splitRemote = parent.m_splitRemote;
        this.m_splitReleasesPrefix = parent.m_splitReleasesPrefix;
        this.m_splitSnapshotsPrefix = parent.m_splitSnapshotsPrefix;
        this.m_splitRemoteRepository = parent.m_splitRemoteRepository;
        this.m_splitRemoteRepositoryLast = parent.m_splitRemoteRepositoryLast;
    }

    public String getId() {
        return this.m_id;
    }

    public URI getURI() {
        return this.m_repositoryURI;
    }

    public String getUsername() {
        return this.m_username;
    }

    public char[] getPassword() {
        return this.m_password;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isReleasesEnabled() {
        return this.m_releasesEnabled;
    }

    public boolean isSnapshotsEnabled() {
        return this.m_snapshotsEnabled;
    }

    public String getReleasesUpdatePolicy() {
        return this.m_releasesUpdatePolicy;
    }

    public String getSnapshotsUpdatePolicy() {
        return this.m_snapshotsUpdatePolicy;
    }

    public String getReleasesChecksumPolicy() {
        return this.m_releasesChecksumPolicy;
    }

    public String getSnapshotsChecksumPolicy() {
        return this.m_snapshotsChecksumPolicy;
    }

    public boolean isMulti() {
        return this.m_multi;
    }

    public boolean isFileRepository() {
        return this.m_file != null;
    }

    public boolean isSplit() {
        return this.m_split;
    }

    public String getSplitLocalPrefix() {
        return this.m_splitLocalPrefix;
    }

    public String getSplitRemotePrefix() {
        return this.m_splitRemotePrefix;
    }

    public boolean isSplitLocal() {
        return this.m_splitLocal;
    }

    public boolean isSplitRemote() {
        return this.m_splitRemote;
    }

    public String getSplitReleasesPrefix() {
        return this.m_splitReleasesPrefix;
    }

    public String getSplitSnapshotsPrefix() {
        return this.m_splitSnapshotsPrefix;
    }

    public boolean isSplitRemoteRepository() {
        return this.m_splitRemoteRepository;
    }

    public boolean isSplitRemoteRepositoryLast() {
        return this.m_splitRemoteRepositoryLast;
    }

    public String toString() {
        return this.m_repositoryURI.toString() + " {id=" + this.m_id + "}";
    }
}

