/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.security.AccessController;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.service.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;

public class PaxLoggerImpl
implements PaxLogger {
    private Logger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    public boolean isTraceEnabled(PaxMarker marker) {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled(PaxMarker marker) {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled(PaxMarker marker) {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled(PaxMarker marker) {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isErrorEnabled(PaxMarker marker) {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled(PaxMarker marker) {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.doLog(Level.TRACE, 4, this.m_fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.doLog(Level.DEBUG, 4, this.m_fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.doLog(Level.INFO, 3, this.m_fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.doLog(Level.WARN, 2, this.m_fqcn, message, t);
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.doLog(Level.ERROR, 1, this.m_fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.doLog(Level.FATAL, 1, this.m_fqcn, message, t);
        }
    }

    public void trace(String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled()) {
            this.doLog(Level.TRACE, 4, fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled()) {
            this.doLog(Level.DEBUG, 4, fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled()) {
            this.doLog(Level.INFO, 3, fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled()) {
            this.doLog(Level.WARN, 2, fqcn, message, t);
        }
    }

    public void error(String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled()) {
            this.doLog(Level.ERROR, 1, fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled()) {
            this.doLog(Level.FATAL, 1, fqcn, message, t);
        }
    }

    public void trace(PaxMarker marker, String message, Throwable t) {
        this.trace(message, t);
    }

    public void debug(PaxMarker marker, String message, Throwable t) {
        this.debug(message, t);
    }

    public void inform(PaxMarker marker, String message, Throwable t) {
        this.inform(message, t);
    }

    public void warn(PaxMarker marker, String message, Throwable t) {
        this.warn(message, t);
    }

    public void error(PaxMarker marker, String message, Throwable t) {
        this.error(message, t);
    }

    public void fatal(PaxMarker marker, String message, Throwable t) {
        this.fatal(message, t);
    }

    public void trace(PaxMarker marker, String message, Throwable t, String fqcn) {
        this.trace(message, t, fqcn);
    }

    public void debug(PaxMarker marker, String message, Throwable t, String fqcn) {
        this.debug(message, t, fqcn);
    }

    public void inform(PaxMarker marker, String message, Throwable t, String fqcn) {
        this.inform(message, t, fqcn);
    }

    public void warn(PaxMarker marker, String message, Throwable t, String fqcn) {
        this.warn(message, t, fqcn);
    }

    public void error(PaxMarker marker, String message, Throwable t, String fqcn) {
        this.error(message, t, fqcn);
    }

    public void fatal(PaxMarker marker, String message, Throwable t, String fqcn) {
        this.fatal(message, t, fqcn);
    }

    public int getLogLevel() {
        Level level = this.m_delegate.getEffectiveLevel();
        if (level == null) {
            return 4;
        }
        if (Level.TRACE.isGreaterOrEqual(level)) {
            return 0;
        }
        if (Level.DEBUG.isGreaterOrEqual(level)) {
            return 1;
        }
        if (Level.INFO.isGreaterOrEqual(level)) {
            return 2;
        }
        if (Level.WARN.isGreaterOrEqual(level)) {
            return 3;
        }
        return 4;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }

    private void doLog(Level level, int svcLevel, String fqcn, String message, Throwable t) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                this.doLog0(level, svcLevel, fqcn, message, t);
                return null;
            });
        } else {
            this.doLog0(level, svcLevel, fqcn, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog0(Level level, int svcLevel, String fqcn, String message, Throwable t) {
        this.setDelegateContext();
        try {
            this.m_delegate.log(fqcn, level, message, t);
        }
        finally {
            this.clearDelegateContext();
        }
        this.m_service.handleEvents(this.m_bundle, null, svcLevel, message, t);
    }

    private void setDelegateContext() {
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            for (Object o : context.keySet()) {
                String key = (String)o;
                Object value = context.get(key);
                MDC.put(key, value);
            }
            context.remove(".log4j2_message");
        }
        if (this.m_bundle != null) {
            this.put("bundle.id", String.valueOf(this.m_bundle.getBundleId()));
            this.put("bundle.name", this.m_bundle.getSymbolicName());
            this.put("bundle.version", this.m_bundle.getVersion().toString());
        }
        this.m_service.lock(false);
    }

    private void put(String name, Object o) {
        if (o != null) {
            MDC.put(name, o);
        }
    }

    private void clearDelegateContext() {
        this.m_service.unlock(false);
        if (MDC.getContext() != null) {
            MDC.getContext().clear();
        }
    }
}

