/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.NameValue;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SortedKeyEnumeration;
import org.apache.log4j.config.PaxPropertySetter;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.ops4j.pax.logging.service.internal.bridges.AppenderBridgeImpl;
import org.ops4j.pax.logging.service.internal.bridges.ErrorHandlerBridgeImpl;
import org.ops4j.pax.logging.service.internal.bridges.FilterBridgeImpl;
import org.ops4j.pax.logging.service.internal.bridges.LayoutBridgeImpl;
import org.ops4j.pax.logging.spi.support.PaxAppenderProxy;
import org.osgi.framework.BundleContext;

public class PaxLoggingConfigurator
extends PropertyConfigurator {
    public static final String OSGI_PREFIX = "osgi:";
    private static final String LOGGER_REF = "logger-ref";
    private static final String ROOT_REF = "root-ref";
    private static final String APPENDER_REF_TAG = "appender-ref";
    private LoggerRepository repository;
    private BundleContext m_bundleContext;
    private List<PaxAppenderProxy> proxies = new ArrayList<PaxAppenderProxy>();

    public PaxLoggingConfigurator(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
    }

    public List<PaxAppenderProxy> getProxies() {
        return this.proxies;
    }

    @Override
    public void doConfigure(Properties properties, LoggerRepository hierarchy) {
        this.repository = hierarchy;
        super.doConfigure(properties, hierarchy);
    }

    @Override
    Appender parseAppender(Properties props, String appenderName) {
        Appender appender = this.registryGet(appenderName);
        if (appender != null) {
            LogLog.debug("Appender \"" + appenderName + "\" was already parsed.");
            return appender;
        }
        if (appenderName.startsWith(OSGI_PREFIX)) {
            String osgiAppenderName = appenderName.substring(OSGI_PREFIX.length());
            PaxAppenderProxy paxAppender = new PaxAppenderProxy(this.m_bundleContext, osgiAppenderName);
            this.proxies.add(paxAppender);
            appender = new AppenderBridgeImpl(paxAppender);
            appender.setName(appenderName);
        } else {
            String prefix = "log4j.appender." + appenderName;
            String layoutPrefix = prefix + ".layout";
            appender = (Appender)OptionConverter.instantiateByKey(props, prefix, Appender.class, null);
            if (appender == null) {
                LogLog.error("Could not instantiate appender named \"" + appenderName + "\".");
                return null;
            }
            appender.setName(appenderName);
            if (appender instanceof OptionHandler) {
                ErrorHandler eh;
                String errorHandlerPrefix;
                String errorHandlerClass;
                if (appender.requiresLayout()) {
                    String layoutClass = OptionConverter.findAndSubst(layoutPrefix, props);
                    if (layoutClass != null && layoutClass.startsWith(OSGI_PREFIX)) {
                        String osgiLayoutName = layoutClass.substring(OSGI_PREFIX.length());
                        Layout fallback = null;
                        String fallbackClass = OptionConverter.findAndSubst(layoutPrefix + ".fallback", props);
                        if (fallbackClass != null && (fallback = (Layout)OptionConverter.instantiateByKey(props, layoutPrefix + ".fallback", Layout.class, null)) != null) {
                            PaxPropertySetter.setProperties(fallback, props, layoutPrefix + ".fallback.");
                        }
                        LayoutBridgeImpl layout = new LayoutBridgeImpl(this.m_bundleContext, osgiLayoutName, fallback);
                        appender.setLayout(layout);
                    } else {
                        Layout layout = (Layout)OptionConverter.instantiateByKey(props, layoutPrefix, Layout.class, null);
                        if (layout != null) {
                            appender.setLayout(layout);
                            LogLog.debug("Parsing layout options for \"" + appenderName + "\".");
                            PaxPropertySetter.setProperties(layout, props, layoutPrefix + ".");
                            LogLog.debug("End of parsing for \"" + appenderName + "\".");
                        }
                    }
                }
                if ((errorHandlerClass = OptionConverter.findAndSubst(errorHandlerPrefix = prefix + ".errorhandler", props)) != null && errorHandlerClass.startsWith(OSGI_PREFIX)) {
                    String errorHandlerName = errorHandlerClass.substring(OSGI_PREFIX.length());
                    ErrorHandler fallback = null;
                    String fallbackClass = OptionConverter.findAndSubst(errorHandlerPrefix + ".fallback", props);
                    if (fallbackClass != null && (fallback = (ErrorHandler)OptionConverter.instantiateByKey(props, errorHandlerPrefix + ".fallback", ErrorHandler.class, null)) != null) {
                        this.parseErrorHandler(fallback, errorHandlerPrefix + ".fallback", props, this.repository);
                    }
                    ErrorHandlerBridgeImpl eh2 = new ErrorHandlerBridgeImpl(this.m_bundleContext, errorHandlerName, fallback);
                    appender.setErrorHandler(eh2);
                } else if (errorHandlerClass != null && (eh = (ErrorHandler)OptionConverter.instantiateByKey(props, errorHandlerPrefix, ErrorHandler.class, null)) != null) {
                    appender.setErrorHandler(eh);
                    LogLog.debug("Parsing errorhandler options for \"" + appenderName + "\".");
                    this.parseErrorHandler(eh, errorHandlerPrefix, props, this.repository);
                    LogLog.debug("End of errorhandler parsing for \"" + appenderName + "\".");
                }
                if (appender instanceof AppenderAttachable) {
                    String appenderPrefix = prefix + ".appenders";
                    String appenderNames = OptionConverter.findAndSubst(appenderPrefix, props);
                    StringTokenizer st = new StringTokenizer(appenderNames, ", ");
                    while (st.hasMoreTokens()) {
                        String childAppenderName = st.nextToken().trim();
                        LogLog.debug("Parsing appender named \"" + childAppenderName + "\".");
                        Appender childAppender = this.parseAppender(props, childAppenderName);
                        if (childAppender == null) continue;
                        ((AppenderAttachable)((Object)appender)).addAppender(childAppender);
                    }
                }
                PaxPropertySetter.setProperties(appender, props, prefix + ".");
                LogLog.debug("Parsed \"" + appenderName + "\" options.");
            }
        }
        this.parseAppenderFilters(props, appenderName, appender);
        this.registryPut(appender);
        return appender;
    }

    private void parseErrorHandler(ErrorHandler eh, String errorHandlerPrefix, Properties props, LoggerRepository hierarchy) {
        Appender backup;
        String appenderName;
        String loggerName;
        boolean rootRef = OptionConverter.toBoolean(OptionConverter.findAndSubst(errorHandlerPrefix + ROOT_REF, props), false);
        if (rootRef) {
            eh.setLogger(hierarchy.getRootLogger());
        }
        if ((loggerName = OptionConverter.findAndSubst(errorHandlerPrefix + LOGGER_REF, props)) != null) {
            Logger logger = this.loggerFactory == null ? hierarchy.getLogger(loggerName) : hierarchy.getLogger(loggerName, this.loggerFactory);
            eh.setLogger(logger);
        }
        if ((appenderName = OptionConverter.findAndSubst(errorHandlerPrefix + APPENDER_REF_TAG, props)) != null && (backup = this.parseAppender(props, appenderName)) != null) {
            eh.setBackupAppender(backup);
        }
        Properties edited = new Properties();
        String[] keys = new String[]{errorHandlerPrefix + "." + ROOT_REF, errorHandlerPrefix + "." + LOGGER_REF, errorHandlerPrefix + "." + APPENDER_REF_TAG};
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            int i;
            for (i = 0; i < keys.length && !keys[i].equals(entry.getKey()); ++i) {
            }
            if (i != keys.length) continue;
            edited.put(entry.getKey(), entry.getValue());
        }
        PaxPropertySetter.setProperties(eh, edited, errorHandlerPrefix + ".");
    }

    @Override
    void parseAppenderFilters(Properties props, String appenderName, Appender appender) {
        String filterPrefix = "log4j.appender." + appenderName + ".filter.";
        int fIdx = filterPrefix.length();
        Hashtable filters = new Hashtable();
        Enumeration<Object> e = props.keys();
        String name = "";
        while (e.hasMoreElements()) {
            Vector<NameValue> filterOpts;
            String key = (String)e.nextElement();
            if (!key.startsWith(filterPrefix)) continue;
            int dotIdx = key.indexOf(46, fIdx);
            String filterKey = key;
            if (dotIdx != -1) {
                filterKey = key.substring(0, dotIdx);
                name = key.substring(dotIdx + 1);
            }
            if ((filterOpts = (Vector<NameValue>)filters.get(filterKey)) == null) {
                filterOpts = new Vector<NameValue>();
                filters.put(filterKey, filterOpts);
            }
            if (dotIdx == -1) continue;
            String value = OptionConverter.findAndSubst(key, props);
            filterOpts.add(new NameValue(name, value));
        }
        SortedKeyEnumeration g = new SortedKeyEnumeration(filters);
        while (g.hasMoreElements()) {
            String key = (String)g.nextElement();
            String clazz = props.getProperty(key);
            if (clazz != null && clazz.startsWith(OSGI_PREFIX)) {
                String filterName = clazz.substring(OSGI_PREFIX.length());
                Filter fallback = null;
                String fallbackClass = OptionConverter.findAndSubst(key + ".fallback", props);
                if (fallbackClass != null && (fallback = (Filter)OptionConverter.instantiateByKey(props, key + ".fallback", Filter.class, null)) != null) {
                    PaxPropertySetter.setProperties(fallback, props, key + ".fallback.");
                }
                FilterBridgeImpl filter = new FilterBridgeImpl(this.m_bundleContext, filterName, fallback);
                appender.addFilter(filter);
                continue;
            }
            if (clazz != null) {
                LogLog.debug("Filter key: [" + key + "] class: [" + props.getProperty(key) + "] props: " + filters.get(key));
                Filter filter = (Filter)OptionConverter.instantiateByClassName(clazz, Filter.class, null);
                if (filter == null) continue;
                PropertySetter propSetter = new PropertySetter(filter);
                Vector v = (Vector)filters.get(key);
                Enumeration filterProps = v.elements();
                while (filterProps.hasMoreElements()) {
                    NameValue kv = (NameValue)filterProps.nextElement();
                    propSetter.setProperty(kv.key, kv.value);
                }
                propSetter.activate();
                LogLog.debug("Adding filter of type [" + filter.getClass() + "] to appender named [" + appender.getName() + "].");
                appender.addFilter(filter);
                continue;
            }
            LogLog.warn("Missing class definition for filter: [" + key + "]");
        }
    }
}

