/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.cm.ConfigurationOption;
import org.ops4j.pax.exam.cm.ConfigurationProvisionOption;

public class ConfigurationAdminOptions {
    private ConfigurationAdminOptions() {
    }

    public static ConfigurationOption newConfiguration(String pid) {
        return new ConfigurationProvisionOption(pid, new HashMap<String, Object>());
    }

    public static ConfigurationOption overrideConfiguration(String pid) {
        return new ConfigurationProvisionOption(pid, new HashMap<String, Object>()).override(true).create(false);
    }

    public static ConfigurationOption factoryConfiguration(String pid) {
        return new ConfigurationProvisionOption(pid, new HashMap<String, Object>()).factory(true);
    }

    public static Option configurationFolder(File folder) {
        return ConfigurationAdminOptions.configurationFolder(folder, ".cfg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Option configurationFolder(File folder, String extension) {
        File[] files;
        if (!folder.exists()) {
            throw new TestContainerException("folder " + folder + " does not exits");
        }
        ArrayList options = new ArrayList();
        for (File file : files = folder.listFiles()) {
            String name;
            if (file.isDirectory() || !(name = file.getName()).endsWith(extension)) continue;
            name = name.substring(0, name.length() - extension.length());
            String[] split = name.split("-");
            ConfigurationProvisionOption cfg = new ConfigurationProvisionOption(split[0], new HashMap<String, Object>());
            cfg.factory(split.length > 1);
            Properties properties = new Properties();
            try (FileInputStream stream = new FileInputStream(file);){
                properties.load(stream);
            }
            catch (IOException e) {
                throw new TestContainerException("can't read configuration file " + file, (Throwable)e);
            }
            Set<String> names = properties.stringPropertyNames();
            for (String key : names) {
                cfg.put(key, properties.getProperty(key));
            }
            options.add(cfg.asOption());
        }
        return CoreOptions.composite((Option[])options.toArray(new Option[0]));
    }
}

