/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.bundle;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.ops4j.pax.construct.util.BndUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class EmbedJarMojo
extends AbstractMojo {
    private ArtifactFactory m_factory;
    private ArtifactMetadataSource m_source;
    private List m_remoteRepos;
    private ArtifactRepository m_localRepo;
    private String groupId;
    private String artifactId;
    private String version;
    private boolean unpack;
    private String exportContents;
    private File targetDirectory;
    private boolean overwrite;

    public void execute() throws MojoExecutionException {
        this.populateMissingFields();
        this.updatePomDependencies();
        this.updateBndInstructions();
    }

    private void populateMissingFields() throws MojoExecutionException {
        if (PomUtils.isEmpty(this.groupId)) {
            this.groupId = this.artifactId;
        }
        if (PomUtils.needReleaseVersion(this.version)) {
            Artifact artifact = this.m_factory.createBuildArtifact(this.groupId, this.artifactId, "RELEASE", "jar");
            this.version = PomUtils.getReleaseVersion(artifact, this.m_source, this.m_remoteRepos, this.m_localRepo, null);
        }
    }

    private void updatePomDependencies() throws MojoExecutionException {
        PomUtils.Pom pom;
        try {
            pom = PomUtils.readPom(this.targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot execute command. It requires a project with an existing pom.xml, but the build is not using one.");
        }
        if (!pom.isBundleProject()) {
            throw new MojoExecutionException("Cannot embed jar inside non-bundle project");
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.groupId);
        dependency.setArtifactId(this.artifactId);
        dependency.setVersion(this.version);
        dependency.setScope("compile");
        dependency.setOptional(true);
        String id = this.groupId + ':' + this.artifactId + ':' + this.version;
        this.getLog().info((CharSequence)("Embedding " + id + " in " + pom));
        pom.addDependency(dependency, this.overwrite);
        try {
            pom.write();
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Problem writing Maven POM: " + pom.getFile());
        }
    }

    private void updateBndInstructions() throws MojoExecutionException {
        BndUtils.Bnd bnd;
        try {
            bnd = BndUtils.readBnd(this.targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem reading Bnd file: " + this.targetDirectory + "/osgi.bnd");
        }
        String embedKey = this.artifactId + ";groupId=" + this.groupId;
        String embedDependency = bnd.getInstruction("Embed-Dependency");
        embedDependency = this.addEmbedClause(embedKey, embedDependency);
        bnd.setInstruction("Embed-Dependency", embedDependency, true);
        if (this.exportContents != null) {
            bnd.setInstruction("-exportcontents", this.exportContents, this.overwrite);
        }
        try {
            bnd.write();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem writing Bnd file: " + bnd.getFile());
        }
    }

    private String addEmbedClause(String embedKey, String embedDependency) {
        String embedClause = embedKey + ";inline=" + this.unpack;
        if (null == embedDependency) {
            return embedClause;
        }
        StringBuffer buf = new StringBuffer();
        String[] clauses = embedDependency.split(",");
        for (int i = 0; i < clauses.length; ++i) {
            String c = clauses[i].trim();
            if (c.length() <= 0 || c.startsWith(embedKey)) continue;
            buf.append(c);
            buf.append(',');
        }
        buf.append(embedClause);
        return buf.toString();
    }
}

