/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.archetype;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ops4j.pax.construct.archetype.AbstractPaxArchetypeMojo;
import org.ops4j.pax.construct.util.BndUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class OSGiProjectArchetypeMojo
extends AbstractPaxArchetypeMojo {
    private static final String OSGI_PROJECT_ARCHETYPE_ID = "maven-archetype-osgi-project";
    private String parentId;
    private String groupId;
    private String artifactId;
    private String version;
    private List m_settingPoms;

    protected void updateExtensionFields() {
        this.setMainArchetype(OSGI_PROJECT_ARCHETYPE_ID);
        this.artifactId = this.artifactId.replaceAll("[/\\\\]+$", "");
        this.setArchetypeProperty("groupId", this.groupId);
        this.setArchetypeProperty("artifactId", this.artifactId);
        this.setArchetypeProperty("version", this.version);
        this.setArchetypeProperty("packageName", this.getCompoundId(this.groupId, this.artifactId));
    }

    protected String getParentId() {
        return this.parentId;
    }

    protected void cacheOriginalFiles(File baseDir) {
        this.m_settingPoms = new ArrayList();
        try {
            PomUtils.Pom pluginSettings = PomUtils.readPom(new File(baseDir, "poms"));
            PomUtils.Pom compiledSettings = PomUtils.readPom(new File(baseDir, "poms/compiled"));
            PomUtils.Pom wrapperSettings = PomUtils.readPom(new File(baseDir, "poms/wrappers"));
            this.m_settingPoms.add(pluginSettings);
            this.m_settingPoms.add(compiledSettings);
            this.m_settingPoms.add(wrapperSettings);
            pluginSettings.getFile().delete();
            compiledSettings.getFile().delete();
            wrapperSettings.getFile().delete();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to cache project settings");
        }
    }

    protected void postProcess(PomUtils.Pom pom, BndUtils.Bnd bnd) {
        pom.updatePluginVersion("org.ops4j", "maven-pax-plugin", this.getPluginVersion());
        this.addTempFiles("poms/imported/");
        this.addTempFiles("osgi.bnd");
        if (null == this.m_settingPoms || this.m_settingPoms.size() == 0) {
            return;
        }
        Iterator i = this.m_settingPoms.iterator();
        while (i.hasNext()) {
            PomUtils.Pom settingsPom = (PomUtils.Pom)i.next();
            try {
                this.saveProjectModel(settingsPom);
                settingsPom.removeModule("imported");
                settingsPom.write();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to merge project settings " + settingsPom));
            }
        }
    }
}

