/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.util.environment;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import org.ops4j.util.environment.EnvironmentException;

public class Environment
extends Properties {
    public static final String OSNAME = System.getProperty("os.name");
    public static final String USERNAME = System.getProperty("user.name");
    private static final HashSet<String> UNICES = new HashSet();
    private static String m_SHELL = null;

    public Environment() throws EnvironmentException {
        Properties properties = Environment.getEnvVariables();
        Enumeration<?> list = properties.propertyNames();
        while (list.hasMoreElements()) {
            String key = (String)list.nextElement();
            this.setProperty(key, properties.getProperty(key));
        }
    }

    public static File getDataDirectory(String applicationname) {
        if (Environment.isUnix()) {
            String prefix = "/home/" + USERNAME + ".";
            String dirname = prefix + applicationname.toLowerCase();
            File dir = new File(dirname);
            Environment.checkDirectoryPathStartsWithPrefix(prefix, dir);
            return dir;
        }
        if (Environment.isWindows()) {
            String prefix = Environment.getEnvVariable("APPDATA") + File.separator;
            String name = Environment.toFirstCap(applicationname);
            String dirname = prefix + name;
            File dir = new File(dirname);
            Environment.checkDirectoryPathStartsWithPrefix(prefix, dir);
            return dir;
        }
        String message = "Environment operations not supported on unrecognized operatings system";
        UnsupportedOperationException cause = new UnsupportedOperationException(message);
        throw new EnvironmentException(cause);
    }

    public static File getSystemDirectory(String applicationname) throws EnvironmentException {
        if (Environment.isUnix()) {
            String name = applicationname.toLowerCase();
            String prefix = "/home/" + USERNAME;
            String dirname = prefix + name;
            File homeDir = new File(dirname);
            Environment.checkDirectoryPathStartsWithPrefix(prefix, homeDir);
            if (homeDir.exists()) {
                return homeDir;
            }
            dirname = "/usr/share/" + name;
            File shareDir = new File(dirname);
            if (shareDir.exists()) {
                return shareDir;
            }
            if ("root".equals(USERNAME)) {
                return shareDir;
            }
            return homeDir;
        }
        if (Environment.isWindows()) {
            String name = Environment.toFirstCap(applicationname);
            String shared = Environment.getEnvVariable("PROGRAMFILES");
            if (shared == null) {
                shared = "C:\\Program Files\\";
            }
            File dir = new File(shared, name);
            Environment.checkDirectoryPathStartsWithPrefix(shared, dir);
            return dir;
        }
        String message = "Environment operations not supported on unrecognized operatings system";
        UnsupportedOperationException cause = new UnsupportedOperationException(message);
        throw new EnvironmentException(cause);
    }

    private static void checkDirectoryPathStartsWithPrefix(String prefix, File dir) {
        try {
            if (!dir.getCanonicalPath().startsWith(prefix)) {
                String message = "The supplied name contains illegal characters";
                UnsupportedOperationException cause = new UnsupportedOperationException(message);
                throw new EnvironmentException(cause);
            }
        }
        catch (IOException e) {
            throw new EnvironmentException(e);
        }
    }

    private static String toFirstCap(String applicationname) {
        char first = applicationname.charAt(0);
        first = Character.toUpperCase(first);
        String name = first + applicationname.substring(1);
        return name;
    }

    public static String getEnvVariable(String name) throws EnvironmentException {
        if (Environment.isUnix()) {
            Properties properties = Environment.getUnixShellVariables();
            return properties.getProperty(name);
        }
        if (Environment.isWindows()) {
            Properties properties = Environment.getWindowsShellVariables();
            return properties.getProperty(name);
        }
        String osName = System.getProperty("os.name");
        throw new EnvironmentException(name, "Non-supported operating system: " + osName);
    }

    public static boolean isUnix() {
        return UNICES.contains(OSNAME);
    }

    public static boolean isMacOsX() {
        return -1 != OSNAME.indexOf("Mac OS X");
    }

    public static boolean isWindows() {
        return -1 != OSNAME.indexOf("Windows");
    }

    public static boolean isNetWare() {
        return -1 != OSNAME.indexOf("netware");
    }

    public static boolean isOpenVMS() {
        return -1 != OSNAME.indexOf("openvms");
    }

    public static Properties getEnvVariables() throws EnvironmentException {
        if (Environment.isUnix()) {
            return Environment.getUnixShellVariables();
        }
        if (Environment.isWindows()) {
            return Environment.getWindowsShellVariables();
        }
        String message = "Environment operations not supported on unrecognized operatings system";
        UnsupportedOperationException cause = new UnsupportedOperationException(message);
        throw new EnvironmentException(cause);
    }

    public static String getUserShell() throws EnvironmentException {
        if (Environment.isMacOsX()) {
            return Environment.getMacUserShell();
        }
        if (Environment.isWindows()) {
            return Environment.getWindowsUserShell();
        }
        if (Environment.isUnix()) {
            return Environment.getUnixUserShell();
        }
        String message = "Environment operations not supported on unrecognized operatings system";
        UnsupportedOperationException cause = new UnsupportedOperationException(message);
        throw new EnvironmentException(cause);
    }

    private static String getWindowsUserShell() {
        if (null != m_SHELL) {
            return m_SHELL;
        }
        if (-1 != OSNAME.indexOf("98") || -1 != OSNAME.indexOf("95") || -1 != OSNAME.indexOf("Me")) {
            m_SHELL = "command.com";
            return m_SHELL;
        }
        m_SHELL = "cmd.exe";
        return m_SHELL;
    }

    private static String getMacUserShell() throws EnvironmentException {
        if (null != m_SHELL) {
            return m_SHELL;
        }
        String[] args = new String[]{"nidump", "passwd", "/"};
        return Environment.readShellFromPasswdFile(args);
    }

    private static String getUnixUserShell() throws EnvironmentException {
        if (null != m_SHELL) {
            return m_SHELL;
        }
        String[] args = new String[]{"cat", "/etc/passwd"};
        return Environment.readShellFromPasswdFile(args);
    }

    private static String readShellFromPasswdFile(String[] args) {
        Process process = null;
        BufferedReader reader = null;
        try {
            process = Environment.startProcess(args);
            reader = Environment.createReader(process);
            Environment.processPasswdFile(reader);
            process.waitFor();
            reader.close();
        }
        catch (InterruptedException t) {
            throw new EnvironmentException(t);
        }
        catch (IOException t) {
            throw new EnvironmentException(t);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            Environment.close(reader);
        }
        String message = "User " + USERNAME + " is not present in the passwd database";
        throw new EnvironmentException(message);
    }

    private static void processPasswdFile(BufferedReader reader) throws IOException {
        String entry = reader.readLine();
        while (null != entry) {
            if (entry.startsWith(USERNAME)) {
                int index = entry.lastIndexOf(58);
                if (index == -1) {
                    String message = "passwd database contains malformed user entry for " + USERNAME;
                    throw new EnvironmentException(message);
                }
                m_SHELL = entry.substring(index + 1);
                break;
            }
            entry = reader.readLine();
        }
    }

    private static Properties getUnixShellVariables() throws EnvironmentException {
        Properties properties = new Properties();
        String cmdExec = Environment.getUnixEnv();
        int exitValue = Environment.readEnvironment(cmdExec, properties);
        if (0 != exitValue) {
            throw new EnvironmentException("Environment process failed  with non-zero exit code of " + exitValue);
        }
        return properties;
    }

    private static String getUnixEnv() throws EnvironmentException {
        File env = new File("/bin/env");
        if (env.exists() && env.canRead() && env.isFile()) {
            return env.getAbsolutePath();
        }
        env = new File("/usr/bin/env");
        if (env.exists() && env.canRead() && env.isFile()) {
            return env.getAbsolutePath();
        }
        String message = "Could not find the UNIX env executable";
        throw new EnvironmentException(message);
    }

    private static Properties getWindowsShellVariables() throws EnvironmentException {
        Properties properties = new Properties();
        StringBuffer buffer = new StringBuffer(Environment.getWindowsUserShell());
        buffer.append(" /C SET");
        String cmdExec = buffer.toString();
        int exitValue = Environment.readEnvironment(cmdExec, properties);
        if (0 != exitValue) {
            String message = "Environment process failed with non-zero exit code of " + exitValue;
            throw new EnvironmentException(message);
        }
        return properties;
    }

    private static void processLinesOfEnvironmentVariables(BufferedReader reader, Properties properties) throws IOException {
        String line = reader.readLine();
        while (null != line) {
            int index = line.indexOf(61);
            if (-1 == index && line.length() != 0) {
                String message = "Skipping line - could not find '=' in line: '" + line + "'";
                System.err.println(message);
            } else {
                String name = line.substring(0, index);
                String value = line.substring(index + 1, line.length());
                properties.setProperty(name, value);
            }
            line = reader.readLine();
        }
    }

    private static Process startProcess(String[] exec) throws IOException {
        Process process = Runtime.getRuntime().exec(exec);
        return process;
    }

    private static BufferedReader createReader(Process process) {
        InputStream inputStream = process.getInputStream();
        InputStreamReader in = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(in);
        return reader;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readEnvironment(String cmdExec, Properties properties) {
        BufferedReader reader = null;
        Process process = null;
        int exitValue = 99;
        try {
            String[] args = new String[]{cmdExec};
            process = Environment.startProcess(args);
            reader = Environment.createReader(process);
            Environment.processLinesOfEnvironmentVariables(reader, properties);
            process.waitFor();
            reader.close();
            if (process != null) {
                process.destroy();
                exitValue = process.exitValue();
            }
        }
        catch (InterruptedException t) {
            try {
                throw new EnvironmentException("NA", t);
                catch (IOException t2) {
                    throw new EnvironmentException("NA", t2);
                }
            }
            catch (Throwable throwable) {
                if (process != null) {
                    process.destroy();
                    exitValue = process.exitValue();
                }
                Environment.close(reader);
                throw throwable;
            }
        }
        Environment.close(reader);
        return exitValue;
    }

    private static void close(BufferedReader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        UNICES.add("Linux");
        UNICES.add("SunOS");
        UNICES.add("Solaris");
        UNICES.add("MPE/iX");
        UNICES.add("AIX");
        UNICES.add("FreeBSD");
        UNICES.add("Irix");
        UNICES.add("Digital Unix");
        UNICES.add("HP-UX");
        UNICES.add("Mac OS X");
    }
}

