/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.commons.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isExpression(String text) {
        if (text == null) {
            return false;
        }
        return (text = text.trim()).startsWith("${") || text.startsWith("#{");
    }

    public static String[] split(String text, String regex) {
        if (text == null) {
            return null;
        }
        if (regex == null) {
            return new String[]{text};
        }
        String[] result = text.split(regex);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static String join(String delimiter, String ... parts) {
        if (parts == null) {
            return null;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                stringBuilder.append(delimiter);
            }
            stringBuilder.append(parts[i]);
        }
        return stringBuilder.toString();
    }

    public static String defaultString(String text) {
        return text == null ? "" : text;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static String sanitize(String input) {
        if (input == null) {
            return "(null)";
        }
        return input.replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t");
    }
}

