/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.identity.Authentication;

public class QueryMaxResultsLimitUtil {
    public static void checkMaxResultsLimit(int resultsCount, int maxResultsLimit, boolean isUserAuthenticated) {
        if (isUserAuthenticated && maxResultsLimit < Integer.MAX_VALUE) {
            if (resultsCount == Integer.MAX_VALUE) {
                throw new BadUserRequestException("An unbound number of results is forbidden!");
            }
            if (resultsCount > maxResultsLimit) {
                throw new BadUserRequestException("Max results limit of " + maxResultsLimit + " exceeded!");
            }
        }
    }

    public static void checkMaxResultsLimit(int resultsCount, ProcessEngineConfigurationImpl processEngineConfig) {
        int maxResultsLimit = processEngineConfig.getQueryMaxResultsLimit();
        QueryMaxResultsLimitUtil.checkMaxResultsLimit(resultsCount, maxResultsLimit, QueryMaxResultsLimitUtil.isUserAuthenticated(processEngineConfig));
    }

    public static void checkMaxResultsLimit(int resultsCount) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration == null) {
            throw new ProcessEngineException("Command context unset.");
        }
        QueryMaxResultsLimitUtil.checkMaxResultsLimit(resultsCount, QueryMaxResultsLimitUtil.getMaxResultsLimit(processEngineConfiguration), QueryMaxResultsLimitUtil.isUserAuthenticated(processEngineConfiguration));
    }

    protected static boolean isUserAuthenticated(ProcessEngineConfigurationImpl processEngineConfig) {
        String userId = QueryMaxResultsLimitUtil.getAuthenticatedUserId(processEngineConfig);
        return userId != null && !userId.isEmpty();
    }

    protected static String getAuthenticatedUserId(ProcessEngineConfigurationImpl processEngineConfig) {
        IdentityService identityService = processEngineConfig.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication == null) {
            return null;
        }
        return currentAuthentication.getUserId();
    }

    protected static int getMaxResultsLimit(ProcessEngineConfigurationImpl processEngineConfig) {
        return processEngineConfig.getQueryMaxResultsLimit();
    }
}

