/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.util.ArrayList;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class PermissionConverter {
    public static Permission[] getPermissionsForNames(String[] names, int resourceType, ProcessEngineConfiguration engineConfiguration) {
        Permission[] permissions = new Permission[names.length];
        for (int i = 0; i < names.length; ++i) {
            permissions[i] = ((ProcessEngineConfigurationImpl)engineConfiguration).getPermissionProvider().getPermissionForName(names[i], resourceType);
        }
        return permissions;
    }

    public static String[] getNamesForPermissions(Authorization authorization, Permission[] permissions) {
        int type = authorization.getAuthorizationType();
        if ((type == 0 || type == 1) && authorization.isEveryPermissionGranted()) {
            return new String[]{Permissions.ALL.getName()};
        }
        if (type == 2 && authorization.isEveryPermissionRevoked()) {
            return new String[]{Permissions.ALL.getName()};
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Permission permission : permissions) {
            String name = permission.getName();
            if (name.equals(Permissions.NONE.getName()) || name.equals(Permissions.ALL.getName())) continue;
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }
}

