/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static Map<String, Object> singletonMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static <T> List<T> asArrayList(T[] values) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, values);
        return result;
    }

    public static <T> Set<T> asHashSet(T ... elements) {
        HashSet set = new HashSet();
        Collections.addAll(set, elements);
        return set;
    }

    public static <S, T> void addToMapOfLists(Map<S, List<T>> map, S key, T value) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        list.add(value);
    }

    public static <S, T> void mergeMapsOfLists(Map<S, List<T>> map, Map<S, List<T>> toAdd) {
        for (Map.Entry<S, List<T>> entry : toAdd.entrySet()) {
            for (T listener : entry.getValue()) {
                CollectionUtil.addToMapOfLists(map, entry.getKey(), listener);
            }
        }
    }

    public static <S, T> void addToMapOfSets(Map<S, Set<T>> map, S key, T value) {
        Set<T> set = map.get(key);
        if (set == null) {
            set = new HashSet<T>();
            map.put(key, set);
        }
        set.add(value);
    }

    public static <S, T> void addCollectionToMapOfSets(Map<S, Set<T>> map, S key, Collection<T> values) {
        Set<T> set = map.get(key);
        if (set == null) {
            set = new HashSet<T>();
            map.put(key, set);
        }
        set.addAll(values);
    }

    public static <T> List<List<T>> partition(List<T> list, int partitionSize) {
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        int listSize = list.size();
        if (listSize <= partitionSize) {
            parts.add(list);
        } else {
            for (int i = 0; i < listSize; i += partitionSize) {
                parts.add(new ArrayList<T>(list.subList(i, Math.min(listSize, i + partitionSize))));
            }
        }
        return parts;
    }

    public static <T> List<T> collectInList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static <T> T getLastElement(Iterable<T> elements) {
        T lastElement = null;
        if (elements instanceof List) {
            return (T)((List)elements).get(((List)elements).size() - 1);
        }
        for (T element : elements) {
            lastElement = element;
        }
        return lastElement;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

