/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.operaton.bpm.engine.ScriptEvaluationException;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.scripting.ExecutableScript;

public abstract class DynamicExecutableScript
extends ExecutableScript {
    protected final Expression scriptExpression;

    protected DynamicExecutableScript(Expression scriptExpression, String language) {
        super(language);
        this.scriptExpression = scriptExpression;
    }

    @Override
    public Object evaluate(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        String source = this.getScriptSource(variableScope);
        try {
            return scriptEngine.eval(source, bindings);
        }
        catch (ScriptException e) {
            String activityIdMessage = this.getActivityIdExceptionMessage(variableScope);
            throw new ScriptEvaluationException("Unable to evaluate script" + activityIdMessage + ": " + e.getMessage(), e);
        }
    }

    protected String evaluateExpression(VariableScope variableScope) {
        return (String)this.scriptExpression.getValue(variableScope);
    }

    public abstract String getScriptSource(VariableScope var1);
}

