/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm.runtime.operation;

import org.operaton.bpm.engine.impl.pvm.PvmException;
import org.operaton.bpm.engine.impl.pvm.PvmLogger;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.Callback;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.operaton.bpm.engine.impl.util.ActivityBehaviorUtil;

public class PvmAtomicOperationActivityExecute
implements PvmAtomicOperation {
    private static final PvmLogger LOG = PvmLogger.PVM_LOGGER;

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        execution.activityInstanceStarted();
        execution.continueIfExecutionDoesNotAffectNextOperation(new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                if (execution.getActivity().isScope()) {
                    execution.dispatchEvent(null);
                }
                return null;
            }
        }, new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                ActivityBehavior activityBehavior = ActivityBehaviorUtil.getActivityBehavior(execution);
                ActivityImpl activity = execution.getActivity();
                LOG.debugExecutesActivity(execution, activity, activityBehavior.getClass().getName());
                try {
                    activityBehavior.execute(execution);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PvmException("couldn't execute activity <" + activity.getProperty("type") + " id=\"" + activity.getId() + "\" ...>: " + e.getMessage(), e);
                }
                return null;
            }
        }, execution);
    }

    @Override
    public String getCanonicalName() {
        return "activity-execute";
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }
}

