/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.operaton.bpm.engine.identity.PasswordPolicyResult;
import org.operaton.bpm.engine.identity.User;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.HasDbRevision;
import org.operaton.bpm.engine.impl.util.EncryptionUtil;

public class UserEntity
implements User,
Serializable,
DbEntity,
HasDbRevision {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String password;
    protected String newPassword;
    protected String salt;
    protected Date lockExpirationTime;
    protected int attempts;

    public UserEntity() {
    }

    public UserEntity(String id) {
        this.id = id;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("firstName", this.firstName);
        persistentState.put("lastName", this.lastName);
        persistentState.put("email", this.email);
        persistentState.put("password", this.password);
        persistentState.put("salt", this.salt);
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.newPassword = password;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setDbPassword(String password) {
        this.password = password;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date lockExpirationTime) {
        this.lockExpirationTime = lockExpirationTime;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public void encryptPassword() {
        if (this.newPassword != null) {
            this.salt = this.generateSalt();
            this.setDbPassword(this.encryptPassword(this.newPassword, this.salt));
        }
    }

    protected String encryptPassword(String password, String salt) {
        if (password == null) {
            return null;
        }
        String saltedPassword = EncryptionUtil.saltPassword(password, salt);
        return Context.getProcessEngineConfiguration().getPasswordManager().encrypt(saltedPassword);
    }

    protected String generateSalt() {
        return Context.getProcessEngineConfiguration().getSaltGenerator().generateSalt();
    }

    public boolean checkPasswordAgainstPolicy() {
        PasswordPolicyResult result = Context.getProcessEngineConfiguration().getIdentityService().checkPasswordAgainstPolicy(this.newPassword, this);
        return result.isValid();
    }

    public boolean hasNewPassword() {
        return this.newPassword != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", password=******, salt=******, lockExpirationTime=" + this.lockExpirationTime + ", attempts=" + this.attempts + "]";
    }
}

