/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.deploy.cache;

import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.operaton.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class OperatonFormDefinitionCache
extends ResourceDefinitionCache<OperatonFormDefinitionEntity> {
    public OperatonFormDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    @Override
    protected AbstractResourceDefinitionManager<OperatonFormDefinitionEntity> getManager() {
        return Context.getCommandContext().getOperatonFormDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid operaton form definition id", "operatonFormDefinitionId", (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with id '" + definitionId + "'", "operatonFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "'", "operatonFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", "operatonFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "', version '" + definitionVersion + "' and tenant-id '" + tenantId + "'", "operatonFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId, OperatonFormDefinitionEntity definition) {
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "' in deployment '" + deploymentId + "'", "operatonFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put operaton form definition '" + definitionId + "' in the cache", "cachedProcessDefinition", (Object)definition);
    }
}

