/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.deploy;

import java.util.Collections;
import java.util.Set;
import org.operaton.bpm.engine.impl.cfg.TransactionListener;
import org.operaton.bpm.engine.impl.cmd.UnregisterDeploymentCmd;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;

public class DeploymentFailListener
implements TransactionListener {
    protected CommandExecutor commandExecutor;
    protected Set<String> deploymentIds;

    public DeploymentFailListener(String deploymentId, CommandExecutor commandExecutor) {
        this.deploymentIds = Collections.singleton(deploymentId);
        this.commandExecutor = commandExecutor;
    }

    public DeploymentFailListener(Set<String> deploymentIds, CommandExecutor commandExecutor) {
        this.deploymentIds = deploymentIds;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public void execute(CommandContext commandContext) {
        this.commandExecutor.execute(new DeleteDeploymentListenerCmd());
    }

    protected class DeleteDeploymentListenerCmd
    implements Command<Void> {
        protected DeleteDeploymentListenerCmd() {
        }

        @Override
        public Void execute(CommandContext commandContext) {
            commandContext.runWithoutAuthorization(new UnregisterDeploymentCmd(DeploymentFailListener.this.deploymentIds));
            return null;
        }
    }
}

