/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.validation.instruction;

import org.operaton.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.tree.FlowScopeWalker;
import org.operaton.bpm.engine.impl.tree.ReferenceWalker;
import org.operaton.bpm.engine.impl.tree.TreeVisitor;

public class CannotAddMultiInstanceBodyValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, final ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl targetActivity = instruction.getTargetActivity();
        FlowScopeWalker flowScopeWalker = new FlowScopeWalker(targetActivity.getFlowScope());
        MiBodyCollector miBodyCollector = new MiBodyCollector();
        flowScopeWalker.addPreVisitor(miBodyCollector);
        flowScopeWalker.walkWhile(new ReferenceWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                return element == null || !instructions.getInstructionsByTargetScope(element).isEmpty();
            }
        });
        if (miBodyCollector.firstMiBody != null) {
            report.addFailure("Target activity '" + targetActivity.getId() + "' is a descendant of multi-instance body '" + miBodyCollector.firstMiBody.getId() + "' that is not mapped from the source process definition.");
        }
    }

    public static class MiBodyCollector
    implements TreeVisitor<ScopeImpl> {
        protected ScopeImpl firstMiBody;

        @Override
        public void visit(ScopeImpl obj) {
            if (this.firstMiBody == null && obj != null && this.isMiBody(obj)) {
                this.firstMiBody = obj;
            }
        }

        protected boolean isMiBody(ScopeImpl scope) {
            return scope.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
        }
    }
}

