/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.validation.instance;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.operaton.bpm.engine.migration.MigratingTransitionInstanceValidationReport;
import org.operaton.bpm.engine.migration.MigrationInstruction;

public class MigratingTransitionInstanceValidationReportImpl
implements MigratingTransitionInstanceValidationReport {
    protected String transitionInstanceId;
    protected String sourceScopeId;
    protected MigrationInstruction migrationInstruction;
    protected List<String> failures = new ArrayList<String>();

    public MigratingTransitionInstanceValidationReportImpl(MigratingTransitionInstance migratingTransitionInstance) {
        this.transitionInstanceId = migratingTransitionInstance.getTransitionInstance().getId();
        this.sourceScopeId = migratingTransitionInstance.getSourceScope().getId();
        this.migrationInstruction = migratingTransitionInstance.getMigrationInstruction();
    }

    @Override
    public String getSourceScopeId() {
        return this.sourceScopeId;
    }

    @Override
    public String getTransitionInstanceId() {
        return this.transitionInstanceId;
    }

    @Override
    public MigrationInstruction getMigrationInstruction() {
        return this.migrationInstruction;
    }

    public void addFailure(String failure) {
        this.failures.add(failure);
    }

    @Override
    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    @Override
    public List<String> getFailures() {
        return this.failures;
    }
}

