/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.cmd.CreateMigrationPlanCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.migration.MigrationInstructionImpl;
import org.operaton.bpm.engine.migration.MigrationInstructionBuilder;
import org.operaton.bpm.engine.migration.MigrationInstructionsBuilder;
import org.operaton.bpm.engine.migration.MigrationPlan;
import org.operaton.bpm.engine.migration.MigrationPlanBuilder;
import org.operaton.bpm.engine.variable.VariableMap;
import org.operaton.bpm.engine.variable.impl.VariableMapImpl;

public class MigrationPlanBuilderImpl
implements MigrationInstructionBuilder,
MigrationInstructionsBuilder {
    protected CommandExecutor commandExecutor;
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected List<MigrationInstructionImpl> explicitMigrationInstructions;
    protected boolean mapEqualActivities = false;
    protected boolean updateEventTriggersForGeneratedInstructions = false;
    protected VariableMap variables;

    public MigrationPlanBuilderImpl(CommandExecutor commandExecutor, String sourceProcessDefinitionId, String targetProcessDefinitionId) {
        this.commandExecutor = commandExecutor;
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
        this.targetProcessDefinitionId = targetProcessDefinitionId;
        this.explicitMigrationInstructions = new ArrayList<MigrationInstructionImpl>();
    }

    @Override
    public MigrationInstructionsBuilder mapEqualActivities() {
        this.mapEqualActivities = true;
        return this;
    }

    @Override
    public MigrationPlanBuilder setVariables(Map<String, ?> variables) {
        if (variables instanceof VariableMapImpl) {
            this.variables = (VariableMapImpl)variables;
        } else if (variables != null) {
            this.variables = new VariableMapImpl(new HashMap(variables));
        }
        return this;
    }

    @Override
    public MigrationInstructionBuilder mapActivities(String sourceActivityId, String targetActivityId) {
        this.explicitMigrationInstructions.add(new MigrationInstructionImpl(sourceActivityId, targetActivityId));
        return this;
    }

    @Override
    public MigrationInstructionBuilder updateEventTrigger() {
        this.explicitMigrationInstructions.get(this.explicitMigrationInstructions.size() - 1).setUpdateEventTrigger(true);
        return this;
    }

    @Override
    public MigrationInstructionsBuilder updateEventTriggers() {
        this.updateEventTriggersForGeneratedInstructions = true;
        return this;
    }

    public String getSourceProcessDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public String getTargetProcessDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public boolean isMapEqualActivities() {
        return this.mapEqualActivities;
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public boolean isUpdateEventTriggersForGeneratedInstructions() {
        return this.updateEventTriggersForGeneratedInstructions;
    }

    public List<MigrationInstructionImpl> getExplicitMigrationInstructions() {
        return this.explicitMigrationInstructions;
    }

    @Override
    public MigrationPlan build() {
        return this.commandExecutor.execute(new CreateMigrationPlanCmd(this));
    }
}

