/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.interceptor;

import java.sql.SQLException;
import java.util.function.Supplier;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.errorcode.BuiltinExceptionCode;
import org.operaton.bpm.engine.impl.errorcode.ExceptionCodeProvider;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandInterceptor;
import org.operaton.bpm.engine.impl.util.ExceptionUtil;

public class ExceptionCodeInterceptor
extends CommandInterceptor {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    public static final int MIN_CUSTOM_CODE = 20000;
    public static final int MAX_CUSTOM_CODE = 39999;
    protected ExceptionCodeProvider builtinExceptionCodeProvider;
    protected ExceptionCodeProvider customExceptionCodeProvider;

    public ExceptionCodeInterceptor(ExceptionCodeProvider builtinExceptionCodeProvider, ExceptionCodeProvider customExceptionCodeProvider) {
        this.builtinExceptionCodeProvider = builtinExceptionCodeProvider;
        this.customExceptionCodeProvider = customExceptionCodeProvider;
    }

    @Override
    public <T> T execute(Command<T> command) {
        try {
            return this.next.execute(command);
        }
        catch (ProcessEngineException pex) {
            this.assignCodeToException(pex);
            throw pex;
        }
    }

    protected Integer provideCodeBySupplier(Supplier<Integer> builtinSupplier, Supplier<Integer> customSupplier, int initialCode) {
        boolean customProviderConfigured;
        Integer providedCode;
        boolean builtinProviderConfigured;
        boolean assignedByDelegationCode = initialCode != BuiltinExceptionCode.FALLBACK.getCode();
        boolean bl = builtinProviderConfigured = this.builtinExceptionCodeProvider != null;
        if (builtinProviderConfigured && (providedCode = builtinSupplier.get()) != null) {
            if (assignedByDelegationCode) {
                LOG.warnResetToBuiltinCode(providedCode, initialCode);
            }
            return providedCode;
        }
        boolean bl2 = customProviderConfigured = this.customExceptionCodeProvider != null;
        if (customProviderConfigured && !assignedByDelegationCode) {
            Integer providedCode2 = customSupplier.get();
            if (providedCode2 != null && builtinProviderConfigured) {
                return this.tryResetReservedCode(providedCode2);
            }
            return providedCode2;
        }
        if (builtinProviderConfigured) {
            return this.tryResetReservedCode(initialCode);
        }
        return null;
    }

    protected Integer provideCode(ProcessEngineException pex, int initialCode) {
        SQLException sqlException = ExceptionUtil.unwrapException(pex);
        Supplier<Integer> builtinSupplier = null;
        Supplier<Integer> customSupplier = null;
        if (sqlException != null) {
            builtinSupplier = () -> this.builtinExceptionCodeProvider.provideCode(sqlException);
            customSupplier = () -> this.customExceptionCodeProvider.provideCode(sqlException);
        } else {
            builtinSupplier = () -> this.builtinExceptionCodeProvider.provideCode(pex);
            customSupplier = () -> this.customExceptionCodeProvider.provideCode(pex);
        }
        return this.provideCodeBySupplier(builtinSupplier, customSupplier, initialCode);
    }

    protected Integer tryResetReservedCode(Integer code) {
        if (this.codeReserved(code)) {
            LOG.warnReservedErrorCode(code);
            return BuiltinExceptionCode.FALLBACK.getCode();
        }
        return code;
    }

    protected boolean codeReserved(Integer code) {
        return code != null && code.intValue() != BuiltinExceptionCode.FALLBACK.getCode() && (code < 20000 || code > 39999);
    }

    protected void assignCodeToException(ProcessEngineException pex) {
        int initialCode = pex.getCode();
        Integer providedCode = this.provideCode(pex, initialCode);
        if (providedCode != null) {
            pex.setCode(providedCode);
        }
    }
}

