/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.interceptor;

import org.operaton.bpm.engine.CrdbTransactionRetryException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandInterceptor;

public class CrdbTransactionRetryInterceptor
extends CommandInterceptor {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected int retries;

    public CrdbTransactionRetryInterceptor(int retries) {
        this.retries = retries;
    }

    @Override
    public <T> T execute(Command<T> command) {
        int remainingTries = this.retries + 1;
        while (remainingTries > 0) {
            try {
                return this.next.execute(command);
            }
            catch (CrdbTransactionRetryException e) {
                if (!this.isRetryable(command) || --remainingTries == 0) {
                    throw e;
                }
                LOG.crdbTransactionRetryAttempt(e);
            }
        }
        return null;
    }

    protected boolean isRetryable(Command<?> command) {
        return command.isRetryable();
    }
}

