/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.interceptor;

import java.lang.reflect.UndeclaredThrowableException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.db.sql.DbSqlSession;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandInterceptor;
import org.operaton.bpm.engine.impl.interceptor.TransactionException;

public abstract class AbstractTransactionInterceptor
extends CommandInterceptor {
    protected final boolean requiresNew;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public AbstractTransactionInterceptor(boolean requiresNew, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.requiresNew = requiresNew;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        T t;
        Object oldTx = null;
        try {
            T result;
            boolean isNew;
            boolean existing = this.isExisting();
            boolean bl = isNew = !existing || this.requiresNew;
            if (existing && this.requiresNew) {
                oldTx = this.doSuspend();
            }
            if (isNew) {
                this.doBegin();
            }
            try {
                result = this.next.execute(command);
            }
            catch (RuntimeException ex) {
                this.doRollback(isNew);
                throw ex;
            }
            catch (Error err) {
                this.doRollback(isNew);
                throw err;
            }
            catch (Exception ex) {
                this.doRollback(isNew);
                throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
            }
            if (isNew) {
                this.doCommit();
            }
            t = result;
            this.doResume(oldTx);
        }
        catch (Throwable throwable) {
            this.doResume(oldTx);
            throw throwable;
        }
        return t;
    }

    protected void handleRollbackException(Exception rollbackException) {
        if (DbSqlSession.isCrdbConcurrencyConflictOnCommit(rollbackException, this.processEngineConfiguration)) {
            throw ProcessEngineLogger.PERSISTENCE_LOGGER.crdbTransactionRetryExceptionOnCommit(rollbackException);
        }
        throw new TransactionException("Unable to commit transaction", rollbackException);
    }

    protected abstract void doResume(Object var1);

    protected abstract void doCommit();

    protected abstract void doRollback(boolean var1);

    protected abstract void doBegin();

    protected abstract Object doSuspend();

    protected abstract boolean isExisting();
}

