/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.history.transformer;

import java.util.List;
import org.operaton.bpm.engine.delegate.CaseExecutionListener;
import org.operaton.bpm.engine.impl.cmmn.handler.ItemHandler;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.operaton.bpm.engine.impl.cmmn.transformer.CmmnTransformListener;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.history.event.HistoryEventTypes;
import org.operaton.bpm.engine.impl.history.producer.CmmnHistoryEventProducer;
import org.operaton.bpm.engine.impl.history.transformer.CaseActivityInstanceCreateListener;
import org.operaton.bpm.engine.impl.history.transformer.CaseActivityInstanceEndListener;
import org.operaton.bpm.engine.impl.history.transformer.CaseActivityInstanceUpdateListener;
import org.operaton.bpm.engine.impl.history.transformer.CaseInstanceCloseListener;
import org.operaton.bpm.engine.impl.history.transformer.CaseInstanceCreateListener;
import org.operaton.bpm.engine.impl.history.transformer.CaseInstanceUpdateListener;
import org.operaton.bpm.model.cmmn.impl.instance.CasePlanModel;
import org.operaton.bpm.model.cmmn.instance.Case;
import org.operaton.bpm.model.cmmn.instance.CaseTask;
import org.operaton.bpm.model.cmmn.instance.DecisionTask;
import org.operaton.bpm.model.cmmn.instance.Definitions;
import org.operaton.bpm.model.cmmn.instance.EventListener;
import org.operaton.bpm.model.cmmn.instance.HumanTask;
import org.operaton.bpm.model.cmmn.instance.Milestone;
import org.operaton.bpm.model.cmmn.instance.PlanItem;
import org.operaton.bpm.model.cmmn.instance.ProcessTask;
import org.operaton.bpm.model.cmmn.instance.Sentry;
import org.operaton.bpm.model.cmmn.instance.Stage;
import org.operaton.bpm.model.cmmn.instance.Task;

public class CmmnHistoryTransformListener
implements CmmnTransformListener {
    protected CaseExecutionListener CASE_INSTANCE_CREATE_LISTENER;
    protected CaseExecutionListener CASE_INSTANCE_UPDATE_LISTENER;
    protected CaseExecutionListener CASE_INSTANCE_CLOSE_LISTENER;
    protected CaseExecutionListener CASE_ACTIVITY_INSTANCE_CREATE_LISTENER;
    protected CaseExecutionListener CASE_ACTIVITY_INSTANCE_UPDATE_LISTENER;
    protected CaseExecutionListener CASE_ACTIVITY_INSTANCE_END_LISTENER;
    protected HistoryLevel historyLevel;

    public CmmnHistoryTransformListener(CmmnHistoryEventProducer historyEventProducer) {
        this.initCaseExecutionListeners(historyEventProducer);
    }

    protected void initCaseExecutionListeners(CmmnHistoryEventProducer historyEventProducer) {
        this.CASE_INSTANCE_CREATE_LISTENER = new CaseInstanceCreateListener(historyEventProducer);
        this.CASE_INSTANCE_UPDATE_LISTENER = new CaseInstanceUpdateListener(historyEventProducer);
        this.CASE_INSTANCE_CLOSE_LISTENER = new CaseInstanceCloseListener(historyEventProducer);
        this.CASE_ACTIVITY_INSTANCE_CREATE_LISTENER = new CaseActivityInstanceCreateListener(historyEventProducer);
        this.CASE_ACTIVITY_INSTANCE_UPDATE_LISTENER = new CaseActivityInstanceUpdateListener(historyEventProducer);
        this.CASE_ACTIVITY_INSTANCE_END_LISTENER = new CaseActivityInstanceEndListener(historyEventProducer);
    }

    @Override
    public void transformRootElement(Definitions definitions, List<? extends CmmnCaseDefinition> caseDefinitions) {
    }

    @Override
    public void transformCase(Case element, CmmnCaseDefinition caseDefinition) {
    }

    @Override
    public void transformCasePlanModel(CasePlanModel casePlanModel, CmmnActivity caseActivity) {
        this.transformCasePlanModel((org.operaton.bpm.model.cmmn.instance.CasePlanModel)casePlanModel, caseActivity);
    }

    @Override
    public void transformCasePlanModel(org.operaton.bpm.model.cmmn.instance.CasePlanModel casePlanModel, CmmnActivity caseActivity) {
        this.addCasePlanModelHandlers(caseActivity);
    }

    @Override
    public void transformHumanTask(PlanItem planItem, HumanTask humanTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformProcessTask(PlanItem planItem, ProcessTask processTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformCaseTask(PlanItem planItem, CaseTask caseTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformDecisionTask(PlanItem planItem, DecisionTask decisionTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformTask(PlanItem planItem, Task task, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformStage(PlanItem planItem, Stage stage, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformMilestone(PlanItem planItem, Milestone milestone, CmmnActivity caseActivity) {
        this.addEventListenerOrMilestoneHandlers(caseActivity);
    }

    @Override
    public void transformEventListener(PlanItem planItem, EventListener eventListener, CmmnActivity caseActivity) {
        this.addEventListenerOrMilestoneHandlers(caseActivity);
    }

    @Override
    public void transformSentry(Sentry sentry, CmmnSentryDeclaration sentryDeclaration) {
    }

    protected void addCasePlanModelHandlers(CmmnActivity caseActivity) {
        this.ensureHistoryLevelInitialized();
        if (caseActivity != null) {
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_INSTANCE_CREATE, null)) {
                for (String event : ItemHandler.CASE_PLAN_MODEL_CREATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_INSTANCE_CREATE_LISTENER);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_INSTANCE_UPDATE, null)) {
                for (String event : ItemHandler.CASE_PLAN_MODEL_UPDATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_INSTANCE_UPDATE_LISTENER);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_INSTANCE_CLOSE, null)) {
                for (String event : ItemHandler.CASE_PLAN_MODEL_CLOSE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_INSTANCE_CLOSE_LISTENER);
                }
            }
        }
    }

    protected void addTaskOrStageHandlers(CmmnActivity caseActivity) {
        this.ensureHistoryLevelInitialized();
        if (caseActivity != null) {
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_CREATE, null)) {
                for (String event : ItemHandler.TASK_OR_STAGE_CREATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_ACTIVITY_INSTANCE_CREATE_LISTENER);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE, null)) {
                for (String event : ItemHandler.TASK_OR_STAGE_UPDATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_ACTIVITY_INSTANCE_UPDATE_LISTENER);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_END, null)) {
                for (String event : ItemHandler.TASK_OR_STAGE_END_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_ACTIVITY_INSTANCE_END_LISTENER);
                }
            }
        }
    }

    protected void addEventListenerOrMilestoneHandlers(CmmnActivity caseActivity) {
        this.ensureHistoryLevelInitialized();
        if (caseActivity != null) {
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_CREATE, null)) {
                for (String event : ItemHandler.EVENT_LISTENER_OR_MILESTONE_CREATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_ACTIVITY_INSTANCE_CREATE_LISTENER);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE, null)) {
                for (String event : ItemHandler.EVENT_LISTENER_OR_MILESTONE_UPDATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_ACTIVITY_INSTANCE_UPDATE_LISTENER);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_END, null)) {
                for (String event : ItemHandler.EVENT_LISTENER_OR_MILESTONE_END_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.CASE_ACTIVITY_INSTANCE_END_LISTENER);
                }
            }
        }
    }

    protected void ensureHistoryLevelInitialized() {
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
    }
}

