/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.history.parser;

import org.operaton.bpm.engine.delegate.DelegateExecution;
import org.operaton.bpm.engine.delegate.ExecutionListener;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.operaton.bpm.engine.impl.history.producer.HistoryEventProducer;

public abstract class HistoryExecutionListener
implements ExecutionListener {
    protected final HistoryEventProducer eventProducer;
    protected HistoryLevel historyLevel;

    public HistoryExecutionListener(HistoryEventProducer historyEventProducer) {
        this.eventProducer = historyEventProducer;
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        HistoryEventHandler historyEventHandler = Context.getProcessEngineConfiguration().getHistoryEventHandler();
        HistoryEvent historyEvent = this.createHistoryEvent(execution);
        if (historyEvent != null) {
            historyEventHandler.handleEvent(historyEvent);
        }
    }

    protected void ensureHistoryLevelInitialized() {
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
    }

    protected abstract HistoryEvent createHistoryEvent(DelegateExecution var1);
}

