/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.type;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class DateFormType
extends AbstractFormFieldType {
    public static final String TYPE_NAME = "date";
    protected String datePattern;
    protected DateFormat dateFormat;

    public DateFormType(String datePattern) {
        this.datePattern = datePattern;
        this.dateFormat = new SimpleDateFormat(datePattern);
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }

    @Override
    public Object getInformation(String key) {
        if ("datePattern".equals(key)) {
            return this.datePattern;
        }
        return null;
    }

    @Override
    public TypedValue convertToModelValue(TypedValue propertyValue) {
        Object value = propertyValue.getValue();
        if (value == null) {
            return Variables.dateValue(null, (boolean)propertyValue.isTransient());
        }
        if (value instanceof Date) {
            return Variables.dateValue((Date)((Date)value), (boolean)propertyValue.isTransient());
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            if (strValue.isEmpty()) {
                return Variables.dateValue(null, (boolean)propertyValue.isTransient());
            }
            try {
                return Variables.dateValue((Date)((Date)this.dateFormat.parseObject(strValue)), (boolean)propertyValue.isTransient());
            }
            catch (ParseException e) {
                throw new ProcessEngineException("Could not parse value '" + value + "' as date using date format '" + this.datePattern + "'.");
            }
        }
        throw new ProcessEngineException("Value '" + value + "' cannot be transformed into a Date.");
    }

    @Override
    public TypedValue convertToFormValue(TypedValue modelValue) {
        if (modelValue.getValue() == null) {
            return Variables.stringValue((String)"", (boolean)modelValue.isTransient());
        }
        if (modelValue.getType() == ValueType.DATE) {
            return Variables.stringValue((String)this.dateFormat.format(modelValue.getValue()), (boolean)modelValue.isTransient());
        }
        throw new ProcessEngineException("Expected value to be of type '" + ValueType.DATE + "' but got '" + modelValue.getType() + "'.");
    }

    @Override
    public Object convertFormValueToModelValue(Object propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        try {
            return this.dateFormat.parseObject(propertyValue.toString());
        }
        catch (ParseException e) {
            throw new ProcessEngineException("invalid date value " + propertyValue);
        }
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        return this.dateFormat.format(modelValue);
    }
}

