/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.engine;

import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.operaton.bpm.engine.impl.form.engine.HtmlDocumentBuilder;

public class HtmlElementWriter {
    protected String tagName;
    protected boolean isSelfClosing;
    protected String textContent;
    protected Map<String, String> attributes = new LinkedHashMap<String, String>();

    public HtmlElementWriter(String tagName) {
        this.tagName = tagName;
        this.isSelfClosing = false;
    }

    public HtmlElementWriter(String tagName, boolean isSelfClosing) {
        this.tagName = tagName;
        this.isSelfClosing = isSelfClosing;
    }

    public void writeStartTag(HtmlDocumentBuilder.HtmlWriteContext context) {
        this.writeLeadingWhitespace(context);
        this.writeStartTagOpen(context);
        this.writeAttributes(context);
        this.writeStartTagClose(context);
        this.writeEndLine(context);
    }

    public void writeContent(HtmlDocumentBuilder.HtmlWriteContext context) {
        if (this.textContent != null) {
            this.writeLeadingWhitespace(context);
            this.writeTextContent(context);
            this.writeEndLine(context);
        }
    }

    public void writeEndTag(HtmlDocumentBuilder.HtmlWriteContext context) {
        if (!this.isSelfClosing) {
            this.writeLeadingWhitespace(context);
            this.writeEndTagElement(context);
            this.writeEndLine(context);
        }
    }

    protected void writeEndTagElement(HtmlDocumentBuilder.HtmlWriteContext context) {
        StringWriter writer = context.getWriter();
        writer.write("</");
        writer.write(this.tagName);
        writer.write(">");
    }

    protected void writeTextContent(HtmlDocumentBuilder.HtmlWriteContext context) {
        StringWriter writer = context.getWriter();
        writer.write("  ");
        writer.write(this.textContent);
    }

    protected void writeStartTagOpen(HtmlDocumentBuilder.HtmlWriteContext context) {
        StringWriter writer = context.getWriter();
        writer.write("<");
        writer.write(this.tagName);
    }

    protected void writeAttributes(HtmlDocumentBuilder.HtmlWriteContext context) {
        StringWriter writer = context.getWriter();
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            writer.write(" ");
            writer.write(attribute.getKey());
            if (attribute.getValue() == null) continue;
            writer.write("=\"");
            String attributeValue = this.escapeQuotes(attribute.getValue());
            writer.write(attributeValue);
            writer.write("\"");
        }
    }

    protected String escapeQuotes(String attributeValue) {
        String escapedHtmlQuote = "&quot;";
        String escapedJavaQuote = "\"";
        return attributeValue.replaceAll(escapedJavaQuote, escapedHtmlQuote);
    }

    protected void writeEndLine(HtmlDocumentBuilder.HtmlWriteContext context) {
        StringWriter writer = context.getWriter();
        writer.write("\n");
    }

    protected void writeStartTagClose(HtmlDocumentBuilder.HtmlWriteContext context) {
        StringWriter writer = context.getWriter();
        if (this.isSelfClosing) {
            writer.write(" /");
        }
        writer.write(">");
    }

    protected void writeLeadingWhitespace(HtmlDocumentBuilder.HtmlWriteContext context) {
        int stackSize = context.getElementStackSize();
        StringWriter writer = context.getWriter();
        for (int i = 0; i < stackSize; ++i) {
            writer.write("  ");
        }
    }

    public HtmlElementWriter attribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public HtmlElementWriter textContent(String text) {
        if (this.isSelfClosing) {
            throw new IllegalStateException("Self-closing element cannot have text content.");
        }
        this.textContent = text;
        return this;
    }
}

