/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.externaltask;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.QueryOperator;
import org.operaton.bpm.engine.impl.QueryVariableValue;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.variable.serializer.VariableSerializers;

public class TopicFetchInstruction
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String topicName;
    protected String businessKey;
    protected String processDefinitionId;
    protected String[] processDefinitionIds;
    protected String processDefinitionKey;
    protected String[] processDefinitionKeys;
    protected String processDefinitionVersionTag;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected List<String> variablesToFetch;
    protected List<QueryVariableValue> filterVariables;
    protected long lockDuration;
    protected boolean deserializeVariables = false;
    protected boolean localVariables = false;
    protected boolean includeExtensionProperties = false;

    public TopicFetchInstruction(String topicName, long lockDuration) {
        this.topicName = topicName;
        this.lockDuration = lockDuration;
        this.filterVariables = new ArrayList<QueryVariableValue>();
    }

    public List<String> getVariablesToFetch() {
        return this.variablesToFetch;
    }

    public void setVariablesToFetch(List<String> variablesToFetch) {
        this.variablesToFetch = variablesToFetch;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionIds(String[] processDefinitionIds) {
        this.processDefinitionIds = processDefinitionIds;
    }

    public String[] getProcessDefinitionIds() {
        return this.processDefinitionIds;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKeys(String[] processDefinitionKeys) {
        this.processDefinitionKeys = processDefinitionKeys;
    }

    public String[] getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public void setProcessDefinitionVersionTag(String processDefinitionVersionTag) {
        this.processDefinitionVersionTag = processDefinitionVersionTag;
    }

    public String getProcessDefinitionVersionTag() {
        return this.processDefinitionVersionTag;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    public void setTenantIdSet(boolean isTenantIdSet) {
        this.isTenantIdSet = isTenantIdSet;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public void setTenantIds(String[] tenantIds) {
        this.isTenantIdSet = true;
        this.tenantIds = tenantIds;
    }

    public List<QueryVariableValue> getFilterVariables() {
        return this.filterVariables;
    }

    public void setFilterVariables(Map<String, Object> filterVariables) {
        for (Map.Entry<String, Object> filter : filterVariables.entrySet()) {
            QueryVariableValue variableValue = new QueryVariableValue(filter.getKey(), filter.getValue(), null, false);
            this.filterVariables.add(variableValue);
        }
    }

    public void addFilterVariable(String name, Object value) {
        QueryVariableValue variableValue = new QueryVariableValue(name, value, QueryOperator.EQUALS, true);
        this.filterVariables.add(variableValue);
    }

    public Long getLockDuration() {
        return this.lockDuration;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean isDeserializeVariables() {
        return this.deserializeVariables;
    }

    public void setDeserializeVariables(boolean deserializeVariables) {
        this.deserializeVariables = deserializeVariables;
    }

    public void ensureVariablesInitialized() {
        if (!this.filterVariables.isEmpty()) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            VariableSerializers variableSerializers = processEngineConfiguration.getVariableSerializers();
            String dbType = processEngineConfiguration.getDatabaseType();
            for (QueryVariableValue queryVariableValue : this.filterVariables) {
                queryVariableValue.initialize(variableSerializers, dbType);
            }
        }
    }

    public boolean isLocalVariables() {
        return this.localVariables;
    }

    public void setLocalVariables(boolean localVariables) {
        this.localVariables = localVariables;
    }

    public boolean isIncludeExtensionProperties() {
        return this.includeExtensionProperties;
    }

    public void setIncludeExtensionProperties(boolean includeExtensionProperties) {
        this.includeExtensionProperties = includeExtensionProperties;
    }
}

