/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.dmn.cmd;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.operaton.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.BatchElementConfiguration;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.CollectionUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricDecisionInstancesBatchCmd
implements Command<Batch> {
    protected List<String> historicDecisionInstanceIds;
    protected HistoricDecisionInstanceQuery historicDecisionInstanceQuery;
    protected String deleteReason;

    public DeleteHistoricDecisionInstancesBatchCmd(List<String> ids, HistoricDecisionInstanceQuery query, String deleteReason) {
        this.historicDecisionInstanceIds = ids;
        this.historicDecisionInstanceQuery = query;
        this.deleteReason = deleteReason;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectHistoricDecisionInstanceIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicDecisionInstanceIds", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("historic-decision-instance-deletion").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected BatchElementConfiguration collectHistoricDecisionInstanceIds(CommandContext commandContext) {
        HistoricDecisionInstanceQueryImpl decisionInstanceQuery;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        if (!CollectionUtil.isEmpty(this.historicDecisionInstanceIds)) {
            HistoricDecisionInstanceQueryImpl query = new HistoricDecisionInstanceQueryImpl();
            query.decisionInstanceIdIn(this.historicDecisionInstanceIds.toArray(new String[0]));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings), this.historicDecisionInstanceIds);
        }
        if ((decisionInstanceQuery = (HistoricDecisionInstanceQueryImpl)this.historicDecisionInstanceQuery) != null) {
            elementConfiguration.addDeploymentMappings(decisionInstanceQuery.listDeploymentIdMappings());
        }
        return elementConfiguration;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("DeleteHistory", null, propertyChanges);
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new BatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings());
    }
}

