/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.dmn;

import java.util.Map;
import org.operaton.bpm.dmn.engine.DmnDecisionResult;
import org.operaton.bpm.engine.dmn.DecisionsEvaluationBuilder;
import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.exception.NullValueException;
import org.operaton.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.dmn.DecisionLogger;
import org.operaton.bpm.engine.impl.dmn.cmd.EvaluateDecisionCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class DecisionEvaluationBuilderImpl
implements DecisionsEvaluationBuilder {
    private static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;
    protected CommandExecutor commandExecutor;
    protected String decisionDefinitionKey;
    protected String decisionDefinitionId;
    protected Integer version;
    protected Map<String, Object> variables;
    protected String decisionDefinitionTenantId;
    protected boolean isTenantIdSet = false;

    public DecisionEvaluationBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public DecisionsEvaluationBuilder variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    @Override
    public DecisionsEvaluationBuilder version(Integer version) {
        this.version = version;
        return this;
    }

    @Override
    public DecisionsEvaluationBuilder decisionDefinitionTenantId(String tenantId) {
        this.decisionDefinitionTenantId = tenantId;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public DecisionsEvaluationBuilder decisionDefinitionWithoutTenantId() {
        this.decisionDefinitionTenantId = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public DmnDecisionResult evaluate() {
        EnsureUtil.ensureOnlyOneNotNull(NotValidException.class, "either decision definition id or key must be set", this.decisionDefinitionId, this.decisionDefinitionKey);
        if (this.isTenantIdSet && this.decisionDefinitionId != null) {
            throw LOG.exceptionEvaluateDecisionDefinitionByIdAndTenantId();
        }
        try {
            return this.commandExecutor.execute(new EvaluateDecisionCmd(this));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    public static DecisionsEvaluationBuilder evaluateDecisionByKey(CommandExecutor commandExecutor, String decisionDefinitionKey) {
        DecisionEvaluationBuilderImpl builder = new DecisionEvaluationBuilderImpl(commandExecutor);
        builder.decisionDefinitionKey = decisionDefinitionKey;
        return builder;
    }

    public static DecisionsEvaluationBuilder evaluateDecisionById(CommandExecutor commandExecutor, String decisionDefinitionId) {
        DecisionEvaluationBuilderImpl builder = new DecisionEvaluationBuilderImpl(commandExecutor);
        builder.decisionDefinitionId = decisionDefinitionId;
        return builder;
    }

    public String getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getDecisionDefinitionTenantId() {
        return this.decisionDefinitionTenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

