/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.db;

import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.db.EnginePersistenceLogger;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class DbSchemaExecuteFile {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw LOG.invokeSchemaResourceToolException(args.length);
        }
        String configurationFileResourceName = args[0];
        final String schemaFileResourceName = args[1];
        EnsureUtil.ensureNotNull("Process engine configuration file name cannot be null", "configurationFileResourceName", (Object)configurationFileResourceName);
        EnsureUtil.ensureNotNull("Schema resource file name cannot be null", "schemaFileResourceName", (Object)schemaFileResourceName);
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(configurationFileResourceName);
        ProcessEngine processEngine = configuration.buildProcessEngine();
        configuration.getCommandExecutorTxRequired().execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                commandContext.getDbSqlSession().executeSchemaResource(schemaFileResourceName);
                return null;
            }
        });
        processEngine.close();
    }
}

