/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.core.variable;

import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.core.CoreLogger;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.operaton.bpm.engine.impl.persistence.entity.util.TypedValueField;
import org.operaton.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import org.operaton.bpm.engine.variable.VariableMap;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.value.SerializableValue;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class VariableUtil {
    public static final CommandLogger CMD_LOGGER = ProcessEngineLogger.CMD_LOGGER;
    public static final CoreLogger CORE_LOGGER = ProcessEngineLogger.CORE_LOGGER;
    public static final String ERROR_MSG = "Cannot set variable with name {0}. Java serialization format is prohibited";

    public static boolean isJavaSerializationProhibited(TypedValue value) {
        SerializableValue serializableValue;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (value instanceof SerializableValue && !processEngineConfiguration.isJavaSerializationFormatEnabled() && !(serializableValue = (SerializableValue)value).isDeserialized()) {
            String requestedDataFormat = serializableValue.getSerializationDataFormat();
            if (requestedDataFormat == null) {
                VariableSerializerFactory fallbackSerializerFactory = processEngineConfiguration.getFallbackSerializerFactory();
                TypedValueSerializer serializerForValue = TypedValueField.getSerializers().findSerializerForValue((TypedValue)serializableValue, fallbackSerializerFactory);
                if (serializerForValue != null) {
                    requestedDataFormat = serializerForValue.getSerializationDataformat();
                }
            }
            return Variables.SerializationDataFormats.JAVA.getName().equals(requestedDataFormat);
        }
        return false;
    }

    public static void checkJavaSerialization(String variableName, TypedValue value) {
        if (VariableUtil.isJavaSerializationProhibited(value)) {
            throw CORE_LOGGER.javaSerializationProhibitedException(variableName);
        }
    }

    public static void setVariables(Map<String, ?> variables, SetVariableFunction setVariableFunction) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                TypedValue value = null;
                value = variables instanceof VariableMap ? ((VariableMap)variables).getValueTyped(variableName) : (TypedValue)variables.get(variableName);
                setVariableFunction.apply(variableName, value);
            }
        }
    }

    public static void setVariablesByBatchId(Map<String, ?> variables, String batchId) {
        VariableUtil.setVariables(variables, (name, value) -> VariableUtil.setVariableByBatchId(batchId, name, value));
    }

    public static void setVariableByBatchId(String batchId, String variableName, Object variableValue) {
        TypedValue variableTypedValue = Variables.untypedValue((Object)variableValue);
        boolean isTransient = variableTypedValue.isTransient();
        if (isTransient) {
            throw CMD_LOGGER.exceptionSettingTransientVariablesAsyncNotSupported(variableName);
        }
        VariableUtil.checkJavaSerialization(variableName, variableTypedValue);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, variableTypedValue);
        variableInstance.setVariableScopeId(batchId);
        variableInstance.setBatchId(batchId);
    }

    public static Map<String, ?> findBatchVariablesSerialized(String batchId, CommandContext commandContext) {
        List<VariableInstanceEntity> variableInstances = commandContext.getVariableInstanceManager().findVariableInstancesByBatchId(batchId);
        return variableInstances.stream().collect(VariableUtil.variablesCollector());
    }

    protected static Collector<VariableInstanceEntity, ?, Map<String, TypedValue>> variablesCollector() {
        return Collectors.toMap(VariableInstanceEntity::getName, VariableUtil::getSerializedValue);
    }

    protected static TypedValue getSerializedValue(VariableInstanceEntity variableInstanceEntity) {
        return variableInstanceEntity.getTypedValue(false);
    }

    @FunctionalInterface
    public static interface SetVariableFunction {
        public void apply(String var1, Object var2);
    }
}

