/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmmn.deployer;

import java.util.List;
import org.operaton.bpm.engine.impl.AbstractDefinitionDeployer;
import org.operaton.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.operaton.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.operaton.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import org.operaton.bpm.engine.impl.core.model.Properties;
import org.operaton.bpm.engine.impl.el.ExpressionManager;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;

public class CmmnDeployer
extends AbstractDefinitionDeployer<CaseDefinitionEntity> {
    public static final String[] CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn11.xml", "cmmn10.xml", "cmmn"};
    protected ExpressionManager expressionManager;
    protected CmmnTransformer transformer;

    @Override
    protected String[] getResourcesSuffixes() {
        return CMMN_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<CaseDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        return this.transformer.createTransform().deployment(deployment).resource(resource).transform();
    }

    @Override
    protected CaseDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getCaseDefinitionManager().findCaseDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected CaseDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getCaseDefinitionManager().findLatestCaseDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(CaseDefinitionEntity definition) {
        this.getCaseDefinitionManager().insertCaseDefinition(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, CaseDefinitionEntity definition) {
        deploymentCache.addCaseDefinition(definition);
    }

    protected CaseDefinitionManager getCaseDefinitionManager() {
        return this.getCommandContext().getCaseDefinitionManager();
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public CmmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(CmmnTransformer transformer) {
        this.transformer = transformer;
    }
}

