/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Collections;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.impl.ModificationBatchConfiguration;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.DeploymentMapping;
import org.operaton.bpm.engine.impl.batch.DeploymentMappings;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;

public class ModifyProcessInstanceAsyncCmd
implements Command<Batch> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstanceModificationBuilderImpl builder;

    public ModifyProcessInstanceAsyncCmd(ProcessInstanceModificationBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(processInstanceId);
        this.ensureProcessInstanceExists(processInstanceId, processInstance);
        String processDefinitionId = processInstance.getProcessDefinitionId();
        String tenantId = processInstance.getTenantId();
        String deploymentId = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId).getDeploymentId();
        return new BatchBuilder(commandContext).type("instance-modification").config(this.getConfiguration(processDefinitionId, deploymentId)).tenantId(tenantId).totalJobs(1).permission(BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES).operationLogHandler(this::writeOperationLog).build();
    }

    protected void ensureProcessInstanceExists(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOG.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected String getLogEntryOperation() {
        return "ModifyProcessInstance";
    }

    protected void writeOperationLog(CommandContext commandContext) {
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), this.builder.getProcessInstanceId(), null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE), this.builder.getAnnotation());
    }

    public BatchConfiguration getConfiguration(String processDefinitionId, String deploymentId) {
        return new ModificationBatchConfiguration(Collections.singletonList(this.builder.getProcessInstanceId()), DeploymentMappings.of(new DeploymentMapping(deploymentId, 1)), processDefinitionId, this.builder.getModificationOperations(), this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
    }
}

