/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.operaton.bpm.engine.impl.telemetry.TelemetryLogger;

public class IsTelemetryEnabledCmd
implements Command<Boolean> {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;

    @Override
    public Boolean execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkOperatonAdminOrPermission(CommandChecker::checkReadTelemetryCollectionStatusData);
        PropertyEntity telemetryProperty = commandContext.getPropertyManager().findPropertyById("operaton.telemetry.enabled");
        if (telemetryProperty != null) {
            if (telemetryProperty.getValue().toLowerCase().equals("null")) {
                return null;
            }
            return Boolean.parseBoolean(telemetryProperty.getValue());
        }
        LOG.databaseTelemetryPropertyMissingInfo();
        return null;
    }
}

