/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.TaskEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class GetTaskVariableCmdTyped
implements Command<TypedValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String variableName;
    protected boolean isLocal;
    protected boolean deserializeValue;

    public GetTaskVariableCmdTyped(String taskId, String variableName, boolean isLocal, boolean deserializeValue) {
        this.taskId = taskId;
        this.variableName = variableName;
        this.isLocal = isLocal;
        this.deserializeValue = deserializeValue;
    }

    @Override
    public TypedValue execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        EnsureUtil.ensureNotNull("variableName", (Object)this.variableName);
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("task " + this.taskId + " doesn't exist", "task", (Object)task);
        this.checkGetTaskVariableTyped(task, commandContext);
        Object value = this.isLocal ? task.getVariableLocalTyped(this.variableName, this.deserializeValue) : task.getVariableTyped(this.variableName, this.deserializeValue);
        return value;
    }

    protected void checkGetTaskVariableTyped(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTaskVariable(task);
        }
    }
}

