/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.task.IdentityLink;

public class GetIdentityLinksForProcessDefinitionCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetIdentityLinksForProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(this.processDefinitionId);
        EnsureUtil.ensureNotNull("Cannot find process definition with id " + this.processDefinitionId, "processDefinition", (Object)processDefinition);
        List<IdentityLink> identityLinks = processDefinition.getIdentityLinks();
        return identityLinks;
    }
}

