/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.UpdateProcessInstancesSuspensionStateBuilderImpl;
import org.operaton.bpm.engine.impl.batch.BatchElementConfiguration;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.CollectionUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractUpdateProcessInstancesSuspendStateCmd<T>
implements Command<T> {
    protected UpdateProcessInstancesSuspensionStateBuilderImpl builder;
    protected CommandExecutor commandExecutor;
    protected boolean suspending;

    public AbstractUpdateProcessInstancesSuspendStateCmd(CommandExecutor commandExecutor, UpdateProcessInstancesSuspensionStateBuilderImpl builder, boolean suspending) {
        this.commandExecutor = commandExecutor;
        this.builder = builder;
        this.suspending = suspending;
    }

    protected BatchElementConfiguration collectProcessInstanceIds(CommandContext commandContext) {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        List<String> processInstanceIds = this.builder.getProcessInstanceIds();
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Cannot be null.", "Process Instance ids", processInstanceIds);
        if (!CollectionUtil.isEmpty(processInstanceIds)) {
            ProcessInstanceQueryImpl query = new ProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(processInstanceIds));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings), processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.builder.getProcessInstanceQuery()) != null) {
            elementConfiguration.addDeploymentMappings(processInstanceQuery.listDeploymentIdMappings());
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.builder.getHistoricProcessInstanceQuery()) != null) {
            elementConfiguration.addDeploymentMappings(historicProcessInstanceQuery.listDeploymentIdMappings());
        }
        return elementConfiguration;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        String operationType = this.suspending ? "SuspendJob" : "ActivateJob";
        commandContext.getOperationLogManager().logProcessInstanceOperation(operationType, null, null, null, propertyChanges);
    }

    protected void writeUserOperationLogAsync(CommandContext commandContext, int numInstances) {
        this.writeUserOperationLog(commandContext, numInstances, true);
    }
}

