/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.impl.batch.BatchEntity;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.operaton.bpm.engine.impl.persistence.entity.BatchManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.persistence.entity.SuspensionState;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetBatchStateCmd
implements Command<Void> {
    public static final String SUSPENSION_STATE_PROPERTY = "suspensionState";
    protected String batchId;

    public AbstractSetBatchStateCmd(String batchId) {
        this.batchId = batchId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Batch id must not be null", "batch id", (Object)this.batchId);
        BatchManager batchManager = commandContext.getBatchManager();
        BatchEntity batch = batchManager.findBatchById(this.batchId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Batch for id '" + this.batchId + "' cannot be found", "batch", (Object)batch);
        this.checkAccess(commandContext, batch);
        this.setJobDefinitionState(commandContext, batch.getSeedJobDefinitionId());
        this.setJobDefinitionState(commandContext, batch.getMonitorJobDefinitionId());
        this.setJobDefinitionState(commandContext, batch.getBatchJobDefinitionId());
        batchManager.updateBatchSuspensionStateById(this.batchId, this.getNewSuspensionState());
        this.logUserOperation(commandContext, batch.getTenantId());
        return null;
    }

    protected abstract SuspensionState getNewSuspensionState();

    protected void checkAccess(CommandContext commandContext, BatchEntity batch) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            this.checkAccess(checker, batch);
        }
    }

    protected abstract void checkAccess(CommandChecker var1, BatchEntity var2);

    protected void setJobDefinitionState(CommandContext commandContext, String jobDefinitionId) {
        this.createSetJobDefinitionStateCommand(jobDefinitionId).execute(commandContext);
    }

    protected AbstractSetJobDefinitionStateCmd createSetJobDefinitionStateCommand(String jobDefinitionId) {
        AbstractSetJobDefinitionStateCmd suspendJobDefinitionCmd = this.createSetJobDefinitionStateCommand(new UpdateJobDefinitionSuspensionStateBuilderImpl().byJobDefinitionId(jobDefinitionId).includeJobs(true));
        suspendJobDefinitionCmd.disableLogUserOperation();
        return suspendJobDefinitionCmd;
    }

    protected abstract AbstractSetJobDefinitionStateCmd createSetJobDefinitionStateCommand(UpdateJobDefinitionSuspensionStateBuilderImpl var1);

    protected void logUserOperation(CommandContext commandContext, String tenantId) {
        PropertyChange propertyChange = new PropertyChange(SUSPENSION_STATE_PROPERTY, null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logBatchOperation(this.getUserOperationType(), this.batchId, tenantId, propertyChange);
    }

    protected abstract String getUserOperationType();
}

